/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform;

import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.ClientOptionalTrait;
import software.amazon.smithy.model.traits.IdempotencyTokenTrait;
import software.amazon.smithy.model.traits.RequiredTrait;
import software.amazon.smithy.model.transform.ModelTransformer;

final class MakeIdempotencyTokenClientOptional {
    private MakeIdempotencyTokenClientOptional() {
    }

    public static Model transform(Model model) {
        return ModelTransformer.create().mapShapes(model, shape -> {
            if (shape.isMemberShape() && shape.hasTrait(RequiredTrait.ID) && shape.hasTrait(IdempotencyTokenTrait.ID) && !shape.hasTrait(ClientOptionalTrait.ID)) {
                return (Shape)((AbstractShapeBuilder)Shape.shapeToBuilder(shape)).addTrait(new ClientOptionalTrait()).build();
            }
            return shape;
        });
    }
}

