/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.BigDecimalShape;
import software.amazon.smithy.model.shapes.BigIntegerShape;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.BooleanShape;
import software.amazon.smithy.model.shapes.ByteShape;
import software.amazon.smithy.model.shapes.DocumentShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.EnumShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.IntEnumShape;
import software.amazon.smithy.model.shapes.IntegerShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.LongShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShortShape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.UnionShape;

public enum ShapeType {
    BLOB("blob", BlobShape.class, Category.SIMPLE),
    BOOLEAN("boolean", BooleanShape.class, Category.SIMPLE),
    STRING("string", StringShape.class, Category.SIMPLE),
    TIMESTAMP("timestamp", TimestampShape.class, Category.SIMPLE),
    BYTE("byte", ByteShape.class, Category.SIMPLE),
    SHORT("short", ShortShape.class, Category.SIMPLE),
    INTEGER("integer", IntegerShape.class, Category.SIMPLE),
    LONG("long", LongShape.class, Category.SIMPLE),
    FLOAT("float", FloatShape.class, Category.SIMPLE),
    DOCUMENT("document", DocumentShape.class, Category.SIMPLE),
    DOUBLE("double", DoubleShape.class, Category.SIMPLE),
    BIG_DECIMAL("bigDecimal", BigDecimalShape.class, Category.SIMPLE),
    BIG_INTEGER("bigInteger", BigIntegerShape.class, Category.SIMPLE),
    ENUM("enum", EnumShape.class, Category.SIMPLE){

        @Override
        public boolean isShapeType(ShapeType other) {
            return this == other || other == STRING;
        }
    }
    ,
    INT_ENUM("intEnum", IntEnumShape.class, Category.SIMPLE){

        @Override
        public boolean isShapeType(ShapeType other) {
            return this == other || other == INTEGER;
        }
    }
    ,
    LIST("list", ListShape.class, Category.AGGREGATE){

        @Override
        public boolean isShapeType(ShapeType other) {
            return this == other || other == SET;
        }
    }
    ,
    SET("set", SetShape.class, Category.AGGREGATE){

        @Override
        public boolean isShapeType(ShapeType other) {
            return this == other || other == LIST;
        }
    }
    ,
    MAP("map", MapShape.class, Category.AGGREGATE),
    STRUCTURE("structure", StructureShape.class, Category.AGGREGATE),
    UNION("union", UnionShape.class, Category.AGGREGATE),
    MEMBER("member", MemberShape.class, Category.MEMBER),
    SERVICE("service", ServiceShape.class, Category.SERVICE),
    RESOURCE("resource", ResourceShape.class, Category.SERVICE),
    OPERATION("operation", OperationShape.class, Category.SERVICE);

    private final String stringValue;
    private final Class<? extends Shape> shapeClass;
    private final Category category;

    private ShapeType(String stringValue, Class<? extends Shape> shapeClass, Category category) {
        this.stringValue = stringValue;
        this.shapeClass = shapeClass;
        this.category = category;
    }

    public String toString() {
        return this.stringValue;
    }

    public Class<? extends Shape> getShapeClass() {
        return this.shapeClass;
    }

    public Category getCategory() {
        return this.category;
    }

    public boolean isShapeType(ShapeType other) {
        return Objects.equals((Object)this, (Object)other);
    }

    public static Optional<ShapeType> fromString(String text) {
        for (ShapeType e : ShapeType.values()) {
            if (!e.stringValue.equals(text)) continue;
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public AbstractShapeBuilder<?, ?> createBuilderForType() {
        switch (this.ordinal()) {
            case 0: {
                return BlobShape.builder();
            }
            case 1: {
                return BooleanShape.builder();
            }
            case 2: {
                return StringShape.builder();
            }
            case 13: {
                return EnumShape.builder();
            }
            case 3: {
                return TimestampShape.builder();
            }
            case 4: {
                return ByteShape.builder();
            }
            case 5: {
                return ShortShape.builder();
            }
            case 6: {
                return IntegerShape.builder();
            }
            case 14: {
                return IntEnumShape.builder();
            }
            case 7: {
                return LongShape.builder();
            }
            case 8: {
                return FloatShape.builder();
            }
            case 9: {
                return DocumentShape.builder();
            }
            case 10: {
                return DoubleShape.builder();
            }
            case 11: {
                return BigDecimalShape.builder();
            }
            case 12: {
                return BigIntegerShape.builder();
            }
            case 15: {
                return ListShape.builder();
            }
            case 16: {
                return SetShape.builder();
            }
            case 17: {
                return MapShape.builder();
            }
            case 18: {
                return StructureShape.builder();
            }
            case 19: {
                return UnionShape.builder();
            }
            case 21: {
                return ServiceShape.builder();
            }
            case 22: {
                return ResourceShape.builder();
            }
            case 23: {
                return OperationShape.builder();
            }
            case 20: {
                return MemberShape.builder();
            }
        }
        throw new IllegalStateException("Invalid shape type: " + (Object)((Object)this));
    }

    public static enum Category {
        SIMPLE,
        AGGREGATE,
        SERVICE,
        MEMBER;

    }
}

