/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.Collection;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.selector.Context;
import software.amazon.smithy.model.selector.InternalSelector;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeType;

final class ShapeTypeSelector
implements InternalSelector {
    final ShapeType shapeType;

    ShapeTypeSelector(ShapeType shapeType) {
        this.shapeType = shapeType;
    }

    @Override
    public InternalSelector.Response push(Context ctx, Shape shape, InternalSelector.Receiver next) {
        if (shape.getType().isShapeType(this.shapeType)) {
            return next.apply(ctx, shape);
        }
        return InternalSelector.Response.CONTINUE;
    }

    @Override
    public Collection<? extends Shape> getStartingShapes(Model model) {
        return model.toSet(this.shapeType.getShapeClass());
    }

    @Override
    public InternalSelector.ContainsShape containsShapeOptimization(Context context, Shape shape) {
        return context.getModel().toSet(this.shapeType.getShapeClass()).contains(shape) ? InternalSelector.ContainsShape.YES : InternalSelector.ContainsShape.NO;
    }
}

