/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.knowledge;

import java.util.List;
import java.util.Optional;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.PaginatedTrait;

public final class PaginationInfo {
    private final ServiceShape service;
    private final OperationShape operation;
    private final StructureShape input;
    private final StructureShape output;
    private final PaginatedTrait paginatedTrait;
    private final MemberShape inputToken;
    private final List<MemberShape> outputToken;
    private final MemberShape pageSize;
    private final List<MemberShape> items;

    PaginationInfo(ServiceShape service, OperationShape operation, StructureShape input, StructureShape output, PaginatedTrait paginatedTrait, MemberShape inputToken, List<MemberShape> outputToken, MemberShape pageSize, List<MemberShape> items) {
        this.service = service;
        this.operation = operation;
        this.input = input;
        this.output = output;
        this.paginatedTrait = paginatedTrait;
        this.inputToken = inputToken;
        this.outputToken = outputToken;
        this.pageSize = pageSize;
        this.items = items;
    }

    public ServiceShape getService() {
        return this.service;
    }

    public OperationShape getOperation() {
        return this.operation;
    }

    public StructureShape getInput() {
        return this.input;
    }

    public StructureShape getOutput() {
        return this.output;
    }

    public PaginatedTrait getPaginatedTrait() {
        return this.paginatedTrait.merge(this.service.getTrait(PaginatedTrait.class).orElse(null));
    }

    public MemberShape getInputTokenMember() {
        return this.inputToken;
    }

    @Deprecated
    public MemberShape getOutputTokenMember() {
        return this.outputToken.get(this.outputToken.size() - 1);
    }

    public List<MemberShape> getOutputTokenMemberPath() {
        return this.outputToken;
    }

    @Deprecated
    public Optional<MemberShape> getItemsMember() {
        int size = this.items.size();
        if (size == 0) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.items.get(size - 1));
    }

    public List<MemberShape> getItemsMemberPath() {
        return this.items;
    }

    public Optional<MemberShape> getPageSizeMember() {
        return Optional.ofNullable(this.pageSize);
    }
}

