/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.neighbor;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Predicate;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NeighborProviderIndex;
import software.amazon.smithy.model.neighbor.NeighborProvider;
import software.amazon.smithy.model.neighbor.Relationship;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.utils.FunctionalUtils;

public final class Walker {
    private final NeighborProvider provider;

    public Walker(Model model) {
        this(NeighborProviderIndex.of(model).getProvider());
    }

    public Walker(NeighborProvider provider) {
        this.provider = provider;
    }

    public Set<Shape> walkShapes(Shape shape) {
        return this.walkShapes(shape, FunctionalUtils.alwaysTrue());
    }

    public Set<Shape> walkShapes(Shape shape, Predicate<Relationship> predicate) {
        LinkedHashSet<Shape> result = new LinkedHashSet<Shape>();
        Iterator<Shape> shapeIterator = this.iterateShapes(shape, predicate);
        while (shapeIterator.hasNext()) {
            result.add(shapeIterator.next());
        }
        return result;
    }

    public Iterator<Shape> iterateShapes(Shape shape) {
        return this.iterateShapes(shape, FunctionalUtils.alwaysTrue());
    }

    public Iterator<Shape> iterateShapes(Shape shape, Predicate<Relationship> predicate) {
        return new ShapeIterator(shape, predicate, this.provider);
    }

    private static final class ShapeIterator
    implements Iterator<Shape> {
        private final Predicate<Relationship> predicate;
        private final Deque<Relationship> stack = new ArrayDeque<Relationship>();
        private final Set<ShapeId> traversed = new HashSet<ShapeId>();
        private final NeighborProvider provider;
        private Shape queued;

        ShapeIterator(Shape shape, Predicate<Relationship> predicate, NeighborProvider provider) {
            this.predicate = predicate;
            this.provider = provider;
            this.queued = shape;
            this.traversed.add(shape.getId());
            this.pushNeighbors(provider.getNeighbors(shape));
        }

        @Override
        public boolean hasNext() {
            if (this.queued != null) {
                return true;
            }
            while (!this.stack.isEmpty()) {
                Relationship relationship = this.stack.pop();
                if (!this.traversed.add(relationship.getNeighborShapeId())) continue;
                this.queued = relationship.getNeighborShape().get();
                this.pushNeighbors(this.provider.getNeighbors(this.queued));
                return true;
            }
            return false;
        }

        @Override
        public Shape next() {
            if (this.queued == null) {
                throw new NoSuchElementException("No relationships in relationship iterator stack");
            }
            Shape shape = this.queued;
            this.queued = null;
            return shape;
        }

        private void pushNeighbors(List<Relationship> relationships) {
            for (Relationship rel : relationships) {
                if (!rel.getNeighborShape().isPresent() || !this.predicate.test(rel)) continue;
                this.stack.push(rel);
            }
        }
    }
}

