/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.neighbor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.neighbor.NodeQuery;
import software.amazon.smithy.model.neighbor.Relationship;
import software.amazon.smithy.model.neighbor.RelationshipType;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.selector.PathFinder;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.IdRefTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.TraitDefinition;

final class IdRefShapeRelationships {
    private static final Selector WITH_ID_REF = Selector.parse("[trait|idRef]");
    private final Model model;
    private final Map<ShapeId, Set<Relationship>> relationships = new HashMap<ShapeId, Set<Relationship>>();

    IdRefShapeRelationships(Model model) {
        this.model = model;
    }

    Map<ShapeId, Set<Relationship>> getRelationships() {
        PathFinder finder = PathFinder.create(this.model);
        for (Shape traitDef : this.model.getShapesWithTrait(TraitDefinition.class)) {
            if (traitDef.hasTrait(IdRefTrait.class)) {
                NodeQuery query = new NodeQuery().self();
                this.addRelationships(traitDef, query);
                continue;
            }
            List<PathFinder.Path> paths = finder.search((ToShapeId)traitDef, WITH_ID_REF);
            if (paths.isEmpty()) continue;
            for (PathFinder.Path path : paths) {
                NodeQuery query = IdRefShapeRelationships.buildNodeQuery(path);
                this.addRelationships(traitDef, query);
            }
        }
        return this.relationships;
    }

    private void addRelationships(Shape traitDef, NodeQuery query) {
        this.model.getShapesWithTrait(traitDef.getId()).forEach(shape -> {
            Trait trait = shape.findTrait(traitDef.getId()).get();
            Node node = trait.toNode();
            query.execute(node).forEach(n -> n.asStringNode().flatMap(StringNode::asShapeId).flatMap(this.model::getShape).map(referenced -> Relationship.create(shape, RelationshipType.ID_REF, referenced)).ifPresent(rel -> this.relationships.computeIfAbsent(rel.getShape().getId(), id -> new HashSet()).add(rel)));
        });
    }

    private static NodeQuery buildNodeQuery(PathFinder.Path path) {
        NodeQuery query = new NodeQuery();
        for (Relationship relationship : path) {
            if (!relationship.getNeighborShape().isPresent()) break;
            switch (relationship.getRelationshipType()) {
                case MAP_KEY: {
                    query.anyMemberName();
                    break;
                }
                case MAP_VALUE: {
                    query.anyMember();
                    break;
                }
                case LIST_MEMBER: 
                case SET_MEMBER: {
                    query.anyElement();
                    break;
                }
                case UNION_MEMBER: 
                case STRUCTURE_MEMBER: {
                    MemberShape member = (MemberShape)relationship.getNeighborShape().get();
                    query.member(member.getMemberName());
                    break;
                }
            }
        }
        return query;
    }
}

