/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.validation.Validator;
import software.amazon.smithy.model.validation.validators.DefaultTraitValidator;
import software.amazon.smithy.model.validation.validators.EnumShapeValidator;
import software.amazon.smithy.model.validation.validators.ExclusiveStructureMemberTraitValidator;
import software.amazon.smithy.model.validation.validators.ResourceCycleValidator;
import software.amazon.smithy.model.validation.validators.ShapeIdConflictValidator;
import software.amazon.smithy.model.validation.validators.SingleOperationBindingValidator;
import software.amazon.smithy.model.validation.validators.SingleResourceBindingValidator;
import software.amazon.smithy.model.validation.validators.TargetValidator;
import software.amazon.smithy.model.validation.validators.TraitConflictValidator;
import software.amazon.smithy.model.validation.validators.TraitTargetValidator;
import software.amazon.smithy.model.validation.validators.TraitValueValidator;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.SmithyInternalApi;

public final class ValidationUtils {
    private static final Set<Class<? extends Validator>> CRITICAL_VALIDATORS = SetUtils.of((Object[])new Class[]{TargetValidator.class, ResourceCycleValidator.class, EnumShapeValidator.class, ExclusiveStructureMemberTraitValidator.class, TraitTargetValidator.class, TraitValueValidator.class, TraitConflictValidator.class, DefaultTraitValidator.class, ShapeIdConflictValidator.class, SingleOperationBindingValidator.class, SingleResourceBindingValidator.class});
    private static final Pattern CAMEL_WORD_SPLITTER = Pattern.compile("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");

    private ValidationUtils() {
    }

    @SmithyInternalApi
    public static boolean isCriticalValidator(Class<? extends Validator> validator) {
        return CRITICAL_VALIDATORS.contains(validator);
    }

    @SmithyInternalApi
    public static boolean isCriticalEvent(String eventId) {
        int slice = eventId.indexOf(".");
        if (slice > 0) {
            eventId = eventId.substring(0, slice);
        }
        for (Class<? extends Validator> c : CRITICAL_VALIDATORS) {
            if (!c.getSimpleName().replace("Validator", "").equals(eventId)) continue;
            return true;
        }
        return false;
    }

    public static List<String> splitCamelCaseWord(String word) {
        return Arrays.asList(CAMEL_WORD_SPLITTER.split(word));
    }

    public static String orderedTickedList(Collection<?> values) {
        if (values.size() == 0) {
            return "";
        }
        StringJoiner joiner = new StringJoiner("`, `", "`", "`");
        for (Object value : values) {
            joiner.add(value.toString());
        }
        return joiner.toString();
    }

    public static String tickedList(Collection<?> values) {
        ArrayList valueList = new ArrayList(values);
        valueList.sort(Comparator.comparing(Object::toString));
        return ValidationUtils.orderedTickedList(valueList);
    }

    public static String tickedList(Stream<?> values) {
        return values.map(Object::toString).sorted().collect(Collectors.joining("`, `", "`", "`"));
    }

    public static String tickedPrettyPrintedNode(Node node) {
        String prettyPrinted = Node.prettyPrintJson(node);
        if (prettyPrinted.contains(System.lineSeparator()) || prettyPrinted.contains("\n")) {
            return String.format("%n```%n%s%n```%n", prettyPrinted);
        }
        if (prettyPrinted.startsWith("\"") && prettyPrinted.endsWith("\"")) {
            return "`" + prettyPrinted.substring(1, prettyPrinted.length() - 1) + "`";
        }
        return "`" + prettyPrinted + "`";
    }

    @Deprecated
    public static <T extends ToShapeId> Map<String, List<ShapeId>> findDuplicateShapeNames(Collection<T> shapes) {
        return shapes.stream().map(ToShapeId::toShapeId).filter(id -> !id.hasMember()).collect(Collectors.groupingBy(id -> id.getName().toLowerCase(Locale.US))).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).sorted(Comparator.comparing(Map.Entry::getKey)).collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            ((List)entry.getValue()).sort(Comparator.comparing(ShapeId::toString));
            return (List)entry.getValue();
        }, (a, b) -> b, LinkedHashMap::new));
    }
}

