/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Function;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NullableIndex;
import software.amazon.smithy.model.loader.LoadOperation;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.loader.Version;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.BooleanNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NullNode;
import software.amazon.smithy.model.node.NumberNode;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.AddedDefaultTrait;
import software.amazon.smithy.model.traits.BoxTrait;
import software.amazon.smithy.model.traits.DefaultTrait;
import software.amazon.smithy.model.traits.StreamingTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.model.validation.ValidationEvent;

final class ModelInteropTransformer {
    private static final EnumSet<ShapeType> HAD_DEFAULT_VALUE_IN_1_0 = EnumSet.of(ShapeType.BYTE, new ShapeType[]{ShapeType.SHORT, ShapeType.INTEGER, ShapeType.LONG, ShapeType.FLOAT, ShapeType.DOUBLE, ShapeType.BOOLEAN, ShapeType.INT_ENUM});
    private final Model model;
    private final List<ValidationEvent> events;
    private final Function<Shape, Version> fileToVersion;
    private final List<Shape> shapeUpgrades = new ArrayList<Shape>();

    ModelInteropTransformer(Model model, List<ValidationEvent> mutableEvents, Function<Shape, Version> fileToVersion) {
        this.model = model;
        this.events = mutableEvents;
        this.fileToVersion = fileToVersion;
    }

    Model transform() {
        for (StructureShape struct : this.model.getStructureShapes()) {
            if (Prelude.isPreludeShape(struct)) continue;
            if (this.fileToVersion.apply(struct) == Version.VERSION_1_0) {
                for (MemberShape member : struct.getAllMembers().values()) {
                    this.model.getShape(member.getTarget()).ifPresent(target -> this.upgradeV1Member(member, (Shape)target));
                }
                continue;
            }
            if (this.fileToVersion.apply(struct) != Version.VERSION_2_0) continue;
            for (MemberShape member : struct.getAllMembers().values()) {
                this.model.getShape(member.getTarget()).ifPresent(target -> this.patchV2MemberForV1Support(member, (Shape)target));
            }
        }
        return ModelTransformer.create().replaceShapes(this.model, this.shapeUpgrades);
    }

    private void upgradeV1Member(MemberShape member, Shape target) {
        if (this.shouldV1MemberHaveDefaultTrait(member, target)) {
            MemberShape.Builder builder = member.toBuilder();
            Node defaultValue = ModelInteropTransformer.getDefaultValueOfType(member, target.getType());
            builder.addTrait(new DefaultTrait(defaultValue));
            this.shapeUpgrades.add(builder.build());
        } else if (member.hasTrait(BoxTrait.class)) {
            MemberShape.Builder builder = member.toBuilder();
            builder.addTrait(new DefaultTrait(new NullNode(member.getSourceLocation())));
            this.shapeUpgrades.add(builder.build());
        }
    }

    private boolean shouldV1MemberHaveDefaultTrait(MemberShape member, Shape target) {
        return (HAD_DEFAULT_VALUE_IN_1_0.contains((Object)target.getType()) || this.streamingBlobNeedsDefault(member, target)) && !member.hasTrait(DefaultTrait.ID) && this.memberAndTargetAreNotAlreadyExplicitlyBoxed(member, target);
    }

    private boolean streamingBlobNeedsDefault(MemberShape member, Shape target) {
        if (member.isRequired()) {
            return false;
        }
        return target.hasTrait(StreamingTrait.ID) && target.isBlobShape();
    }

    private void patchV2MemberForV1Support(MemberShape member, Shape target) {
        if (!this.canBoxTargetThisKindOfShape(target)) {
            return;
        }
        if (!this.memberDoesNotHaveDefaultZeroValueTrait(member, target)) {
            return;
        }
        if (member.hasNullDefault() || this.v2ShapeNeedsBoxTrait(member, target)) {
            this.shapeUpgrades.add(((MemberShape.Builder)member.toBuilder().addTrait(new BoxTrait())).build());
        }
    }

    private boolean v2ShapeNeedsBoxTrait(MemberShape member, Shape target) {
        return this.isMemberInherentlyBoxedInV1(member) && this.memberAndTargetAreNotAlreadyExplicitlyBoxed(member, target);
    }

    private boolean canBoxTargetThisKindOfShape(Shape target) {
        return HAD_DEFAULT_VALUE_IN_1_0.contains((Object)target.getType());
    }

    private boolean memberAndTargetAreNotAlreadyExplicitlyBoxed(MemberShape member, Shape target) {
        return !member.hasTrait(BoxTrait.ID) && !target.hasTrait(BoxTrait.ID);
    }

    private boolean isMemberInherentlyBoxedInV1(MemberShape member) {
        return member.hasTrait(AddedDefaultTrait.class);
    }

    private boolean memberDoesNotHaveDefaultZeroValueTrait(MemberShape member, Shape target) {
        return !NullableIndex.isShapeSetToDefaultZeroValueInV1(member, target);
    }

    static void patchShapeBeforeBuilding(LoadOperation.DefineShape defineShape, AbstractShapeBuilder<?, ?> builder, List<ValidationEvent> events) {
        ModelInteropTransformer.handleBoxing(defineShape, builder);
    }

    private static void handleBoxing(LoadOperation.DefineShape defineShape, AbstractShapeBuilder<?, ?> builder) {
        Trait defaultTrait;
        Node defaultValue;
        boolean isDefaultZeroValue;
        if (!HAD_DEFAULT_VALUE_IN_1_0.contains((Object)builder.getShapeType())) {
            return;
        }
        if (defineShape.version == Version.VERSION_1_0) {
            if (!ModelInteropTransformer.isBuilderBoxed(builder)) {
                Node defaultZeroValue = ModelInteropTransformer.getDefaultValueOfType(builder, builder.getShapeType());
                DefaultTrait syntheticDefault = new DefaultTrait(defaultZeroValue);
                builder.addTrait(syntheticDefault);
            }
        } else if (defineShape.version == Version.VERSION_2_0 && !(isDefaultZeroValue = NullableIndex.isDefaultZeroValueOfTypeInV1(defaultValue = (defaultTrait = builder.getAllTraits().get(DefaultTrait.ID)) == null ? null : defaultTrait.toNode(), defineShape.getShapeType()))) {
            builder.addTrait(new BoxTrait());
        }
    }

    private static boolean isBuilderBoxed(AbstractShapeBuilder<?, ?> builder) {
        return builder.getAllTraits().containsKey(BoxTrait.ID);
    }

    private static Node getDefaultValueOfType(FromSourceLocation sourceLocation, ShapeType type) {
        switch (type) {
            case BOOLEAN: {
                return new BooleanNode(false, sourceLocation.getSourceLocation());
            }
            case BYTE: 
            case SHORT: 
            case INTEGER: 
            case INT_ENUM: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BIG_DECIMAL: 
            case BIG_INTEGER: {
                return new NumberNode(0, sourceLocation.getSourceLocation());
            }
            case BLOB: 
            case STRING: {
                return new StringNode("", sourceLocation.getSourceLocation());
            }
            case LIST: 
            case SET: {
                return new ArrayNode(Collections.emptyList(), sourceLocation.getSourceLocation());
            }
            case MAP: {
                return new ObjectNode(Collections.emptyMap(), sourceLocation.getSourceLocation());
            }
            case DOCUMENT: {
                return new NullNode(sourceLocation.getSourceLocation());
            }
        }
        throw new UnsupportedOperationException("Unexpected shape type: " + (Object)((Object)type));
    }
}

