/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.model.transform.ModelTransformerPlugin;

public final class CleanOperationStructures
implements ModelTransformerPlugin {
    @Override
    public Model onRemove(ModelTransformer transformer, Collection<Shape> removed, Model model) {
        return transformer.replaceShapes(model, this.getModifiedOperations(model, removed));
    }

    private Collection<Shape> getModifiedOperations(Model model, Collection<Shape> removed) {
        return model.shapes(OperationShape.class).flatMap(operation -> {
            OperationShape result = this.transformErrors(removed, (OperationShape)operation);
            result = this.transformInput(removed, result);
            return (result = this.transformOutput(removed, result)).equals(operation) ? Stream.empty() : Stream.of(result);
        }).collect(Collectors.toList());
    }

    private OperationShape transformInput(Collection<Shape> removed, OperationShape operation) {
        for (Shape remove : removed) {
            if (!remove.getId().equals(operation.getInputShape())) continue;
            return operation.toBuilder().input(null).build();
        }
        return operation;
    }

    private OperationShape transformOutput(Collection<Shape> removed, OperationShape operation) {
        for (Shape remove : removed) {
            if (!remove.getId().equals(operation.getOutputShape())) continue;
            return operation.toBuilder().output(null).build();
        }
        return operation;
    }

    private OperationShape transformErrors(Collection<Shape> removed, OperationShape operation) {
        HashSet<ShapeId> errors = new HashSet<ShapeId>(operation.getErrors());
        removed.forEach(shape -> errors.remove(shape.getId()));
        if (new ArrayList<ShapeId>(errors).equals(operation.getErrors())) {
            return operation;
        }
        return operation.toBuilder().errors(errors).build();
    }
}

