/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.Optional;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.TraitService;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class PropertyTrait
extends AbstractTrait
implements ToSmithyBuilder<PropertyTrait> {
    public static final ShapeId ID = ShapeId.from("smithy.api#property");
    private final String name;

    private PropertyTrait(Builder builder) {
        super(ID, builder.sourceLocation);
        this.name = builder.name;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @Override
    protected Node createNode() {
        return Node.objectNodeBuilder().sourceLocation(this.getSourceLocation()).withOptionalMember("name", this.getName().map(Node::from)).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ((Builder)PropertyTrait.builder().sourceLocation(this.getSourceLocation())).name(this.name);
    }

    public static final class Builder
    extends AbstractTraitBuilder<PropertyTrait, Builder> {
        private String name;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public PropertyTrait build() {
            return new PropertyTrait(this);
        }
    }

    public static final class Provider
    implements TraitService {
        @Override
        public ShapeId getShapeId() {
            return ID;
        }

        @Override
        public PropertyTrait createTrait(ShapeId target, Node value) {
            Builder builder = (Builder)PropertyTrait.builder().sourceLocation(value.getSourceLocation());
            value.expectObjectNode().getStringMember("name", builder::name);
            PropertyTrait result = builder.build();
            result.setNodeCache(value);
            return result;
        }
    }
}

