/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.Shape;

final class IdentitySelector
implements Selector {
    IdentitySelector() {
    }

    @Override
    public Set<Shape> select(Model model) {
        return model.toSet();
    }

    @Override
    public Stream<Shape> shapes(Model model) {
        return model.shapes();
    }

    @Override
    public Stream<Selector.ShapeMatch> matches(Model model) {
        return model.shapes().map(shape -> new Selector.ShapeMatch((Shape)shape, Collections.emptyMap()));
    }

    public String toString() {
        return "*";
    }

    public boolean equals(Object other) {
        return other instanceof Selector && this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

