/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.ExpectationNotMetException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;

public final class NodePointer {
    private static final Logger LOGGER = Logger.getLogger(NodePointer.class.getName());
    private static final NodePointer EMPTY = new NodePointer("", Collections.emptyList());
    private final String originalString;
    private final List<String> parts;

    private NodePointer(String originalString, List<String> parts) {
        this.originalString = originalString;
        this.parts = parts;
    }

    public static NodePointer empty() {
        return EMPTY;
    }

    public static NodePointer fromNode(Node node) {
        try {
            String value = node.expectStringNode().getValue();
            return NodePointer.parse(value);
        }
        catch (RuntimeException e) {
            String message = "Expected a string containing a valid JSON pointer: " + e.getMessage();
            throw new ExpectationNotMetException(message, node);
        }
    }

    public static String unescape(String pointerPart) {
        if (!pointerPart.contains("~")) {
            return pointerPart;
        }
        return pointerPart.replace("~1", "/").replace("~0", "~");
    }

    public static NodePointer parse(String pointer) {
        return pointer.isEmpty() ? NodePointer.empty() : new NodePointer(pointer, NodePointer.parseJsonPointer(pointer));
    }

    private static List<String> parseJsonPointer(String pointer) {
        if (pointer.isEmpty()) {
            return Collections.emptyList();
        }
        if (pointer.startsWith("#")) {
            return NodePointer.parseJsonPointer(pointer.substring(1));
        }
        if (!pointer.startsWith("/")) {
            throw new IllegalArgumentException("JSON pointer must start with '/': " + pointer);
        }
        ArrayList<String> parts = new ArrayList<String>();
        int start = 0;
        for (int i = 0; i < pointer.length(); ++i) {
            if (pointer.charAt(i) != '/') continue;
            if (start > 0) {
                String part = pointer.substring(start, i);
                parts.add(NodePointer.unescape(part));
            }
            start = i + 1;
        }
        parts.add(NodePointer.unescape(pointer.substring(start)));
        return parts;
    }

    public List<String> getParts() {
        return Collections.unmodifiableList(this.parts);
    }

    public String toString() {
        return this.originalString;
    }

    public boolean equals(Object other) {
        return other instanceof NodePointer && other.toString().equals(this.toString());
    }

    public int hashCode() {
        return this.originalString.hashCode();
    }

    public Node getValue(Node container) {
        Node result = container;
        for (String part : this.parts) {
            if (result.asObjectNode().isPresent()) {
                result = result.expectObjectNode().getMember(part).orElse(Node.nullNode());
                continue;
            }
            if (result.asArrayNode().isPresent()) {
                ArrayNode array = result.expectArrayNode();
                if (part.equals("-")) {
                    return array.get(array.size() - 1).orElse(Node.nullNode());
                }
                result = array.get(this.parseIntPart(part)).orElse(Node.nullNode());
                continue;
            }
            return Node.nullNode();
        }
        return result;
    }

    public Node addValue(Node container, Node value) {
        return this.addWithFlag(container, value, false);
    }

    public Node addWithIntermediateValues(Node container, Node value) {
        return this.addWithFlag(container, value, true);
    }

    private Node addWithFlag(Node container, Node value, boolean intermediate) {
        if (this.parts.isEmpty()) {
            return value;
        }
        return this.addValue(container, value, 0, intermediate);
    }

    private Node addValue(Node container, Node value, int partPosition, boolean intermediate) {
        boolean isLast;
        String part = this.parts.get(partPosition);
        boolean bl = isLast = partPosition == this.parts.size() - 1;
        if (container.isObjectNode()) {
            return this.addObjectMember(part, isLast, container.expectObjectNode(), value, partPosition, intermediate);
        }
        if (container.isArrayNode()) {
            return this.addArrayMember(part, isLast, container.expectArrayNode(), value, partPosition, intermediate);
        }
        LOGGER.warning(() -> String.format("Attempted to add a value through JSON pointer `%s`, but segment %d targets %s", this.toString(), partPosition, Node.printJson(container)));
        return container;
    }

    private Node addObjectMember(String part, boolean isLast, ObjectNode container, Node value, int partPosition, boolean intermediate) {
        if (isLast) {
            return container.withMember(part, value);
        }
        if (container.getMember(part).isPresent()) {
            Node member = container.expectMember(part);
            Node updatedMember = this.addValue(member, value, partPosition + 1, intermediate);
            return container.withMember(part, updatedMember);
        }
        if (intermediate) {
            Node synthesized = this.addValue(Node.objectNode(), value, partPosition + 1, intermediate);
            return container.withMember(part, synthesized);
        }
        LOGGER.warning(() -> String.format("Attempted to add a value through JSON pointer `%s`, but `%s` could not be found in %s", this.toString(), part, Node.printJson(container)));
        return container;
    }

    private Node addArrayMember(String part, boolean isLast, ArrayNode container, Node value, int partPosition, boolean intermediate) {
        if (!isLast) {
            int partInt;
            int n = partInt = part.equals("-") ? container.size() - 1 : this.parseIntPart(part);
            if (container.get(partInt).isPresent()) {
                Node item = container.get(partInt).get();
                ArrayList<Node> list = new ArrayList<Node>(container.getElements());
                list.set(partInt, this.addValue(item, value, partPosition + 1, intermediate));
                return new ArrayNode(list, container.getSourceLocation());
            }
            this.logInvalidArrayIndex(container, partInt);
            return container;
        }
        if (part.equals("-")) {
            return container.withValue(value);
        }
        int partInt = this.parseIntPart(part);
        if (partInt > -1 && container.size() >= partInt) {
            ArrayList<Node> list = new ArrayList<Node>(container.getElements());
            list.add(partInt, value);
            return new ArrayNode(list, container.getSourceLocation());
        }
        this.logInvalidArrayIndex(container, partInt);
        return container;
    }

    private void logInvalidArrayIndex(Node container, int partInt) {
        LOGGER.warning(() -> String.format("Attempted to add a value through JSON pointer `%s`, but index %d could not be set in %s", this.toString(), partInt, Node.printJson(container)));
    }

    private int parseIntPart(String part) {
        try {
            return Integer.parseInt(part);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }
}

