/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.ServiceIndex;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.AuthTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public class ServiceAuthDefinitionsValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        ServiceIndex index = ServiceIndex.of(model);
        List services = model.getServiceShapes().stream().filter(serviceShape -> !serviceShape.hasTrait(AuthTrait.ID)).filter(serviceShape -> index.getAuthSchemes((ToShapeId)serviceShape).size() > 1).collect(Collectors.toList());
        for (ServiceShape service : services) {
            events.add(this.warning(service, "This service uses multiple authentication schemes but does not have the `@auth` trait applied. The `@auth` trait defines a priority ordering of auth schemes for a client to use. Without it, the ordering of auth schemes is alphabetical based on the absolute shape ID of the auth schemes."));
        }
        return events;
    }
}

