/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.neighbor;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NeighborProviderIndex;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.neighbor.Walker;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.utils.FunctionalUtils;

public final class UnreferencedTraitDefinitions {
    private final Predicate<Shape> keepFilter;

    public UnreferencedTraitDefinitions() {
        this(FunctionalUtils.alwaysTrue());
    }

    public UnreferencedTraitDefinitions(Predicate<Shape> keepFilter) {
        this.keepFilter = keepFilter;
    }

    public Set<Shape> compute(Model model) {
        Walker walker = new Walker(NeighborProviderIndex.of(model).getProvider());
        Set<Shape> unused = model.getShapesWithTrait(TraitDefinition.class).stream().filter(FunctionalUtils.not(Prelude::isPreludeShape)).collect(Collectors.toSet());
        model.shapes(ServiceShape.class).flatMap(service -> walker.walkShapes((Shape)service).stream()).distinct().map(Shape::getAllTraits).flatMap(traits -> traits.keySet().stream()).distinct().flatMap(traitId -> this.getTraitShapes(model, (ShapeId)traitId).stream()).filter(this.keepFilter).forEach(unused::remove);
        return unused;
    }

    private Collection<Shape> getTraitShapes(Model model, ShapeId traitId) {
        return this.getTraitShapes(model, traitId, new HashMap<ShapeId, Shape>()).values();
    }

    private Map<ShapeId, Shape> getTraitShapes(Model model, ShapeId traitId, Map<ShapeId, Shape> traitShapes) {
        Optional<Shape> initialTraitShapeOp = model.getShape(traitId);
        if (initialTraitShapeOp.isPresent()) {
            Shape initialTraitShape = initialTraitShapeOp.get();
            traitShapes.put(traitId, initialTraitShape);
            for (ShapeId metaTraitId : initialTraitShape.getAllTraits().keySet()) {
                if (metaTraitId.equals(TraitDefinition.ID) || traitShapes.containsKey(metaTraitId)) continue;
                traitShapes.putAll(this.getTraitShapes(model, metaTraitId, traitShapes));
            }
        }
        return traitShapes;
    }
}

