/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.LoaderUtils;
import software.amazon.smithy.model.loader.ModelAssembler;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.loader.ValidationLoader;
import software.amazon.smithy.model.loader.ValidatorDefinition;
import software.amazon.smithy.model.loader.ValidatorFromDefinitionFactory;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidatedResult;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationEventDecorator;
import software.amazon.smithy.model.validation.Validator;
import software.amazon.smithy.model.validation.ValidatorFactory;
import software.amazon.smithy.model.validation.suppressions.ModelBasedEventDecorator;
import software.amazon.smithy.model.validation.suppressions.SeverityOverride;
import software.amazon.smithy.model.validation.validators.ResourceCycleValidator;
import software.amazon.smithy.model.validation.validators.TargetValidator;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.SmithyBuilder;

final class ModelValidator
implements Validator {
    private static final Set<Class<? extends Validator>> CORE_VALIDATORS = SetUtils.of((Object[])new Class[]{TargetValidator.class, ResourceCycleValidator.class});
    private final ValidatorFactory validatorFactory;
    private final List<ValidationEvent> events = new ArrayList<ValidationEvent>();
    private final List<Validator> validators = new ArrayList<Validator>();
    private final List<SeverityOverride> severityOverrides = new ArrayList<SeverityOverride>();
    private final ValidationEventDecorator validationEventDecorator;
    private final Consumer<ValidationEvent> eventListener;

    ModelValidator(Builder builder) {
        this.validatorFactory = builder.validatorFactory;
        this.eventListener = builder.eventListener;
        this.validationEventDecorator = builder.validationEventDecorator;
        this.events.addAll(builder.includeEvents);
        this.validators.addAll(builder.validators);
    }

    @Override
    public List<ValidationEvent> validate(Model model) {
        return new LoadedModelValidator(model, this).validate();
    }

    static Builder builder() {
        return new Builder();
    }

    static ValidatorFactory defaultValidationFactory() {
        return LazyValidatorFactoryHolder.INSTANCE;
    }

    static final class Builder
    implements SmithyBuilder<ModelValidator> {
        private final List<Validator> validators = new ArrayList<Validator>();
        private final List<ValidationEvent> includeEvents = new ArrayList<ValidationEvent>();
        private ValidatorFactory validatorFactory = LazyValidatorFactoryHolder.INSTANCE;
        private Consumer<ValidationEvent> eventListener = event -> {};
        private ValidationEventDecorator validationEventDecorator;

        private Builder() {
        }

        public Builder validators(Collection<? extends Validator> validators) {
            this.validators.clear();
            validators.forEach(this::addValidator);
            return this;
        }

        public Builder addValidator(Validator validator) {
            this.validators.add(Objects.requireNonNull(validator));
            return this;
        }

        public Builder validatorFactory(ValidatorFactory validatorFactory, ValidationEventDecorator validationEventDecorator) {
            this.validatorFactory = Objects.requireNonNull(validatorFactory);
            this.validationEventDecorator = validationEventDecorator;
            return this;
        }

        public Builder eventListener(Consumer<ValidationEvent> eventListener) {
            this.eventListener = Objects.requireNonNull(eventListener);
            return this;
        }

        public Builder includeEvents(List<ValidationEvent> events) {
            this.includeEvents.clear();
            this.includeEvents.addAll(events);
            return this;
        }

        public ModelValidator build() {
            this.validators.addAll(this.validatorFactory.loadBuiltinValidators());
            this.validators.removeIf(v -> CORE_VALIDATORS.contains(v.getClass()));
            return new ModelValidator(this);
        }
    }

    private static final class LoadedModelValidator {
        private final Model model;
        private final List<SeverityOverride> severityOverrides;
        private final List<Validator> validators;
        private final List<ValidationEvent> events = new ArrayList<ValidationEvent>();
        private final ValidationEventDecorator validationEventDecorator;
        private final Consumer<ValidationEvent> eventListener;

        private LoadedModelValidator(Model model, ModelValidator validator) {
            this.model = model;
            this.eventListener = validator.eventListener;
            this.severityOverrides = new ArrayList<SeverityOverride>(validator.severityOverrides);
            this.validators = new ArrayList<Validator>(validator.validators);
            ModelBasedEventDecorator modelBasedEventDecorator = new ModelBasedEventDecorator();
            modelBasedEventDecorator.severityOverrides(validator.severityOverrides);
            ValidatedResult<ValidationEventDecorator> result = modelBasedEventDecorator.createDecorator(model);
            this.validationEventDecorator = result.getResult().map(decorator -> ValidationEventDecorator.compose(ListUtils.of((Object)decorator, (Object)validator.validationEventDecorator))).orElse(validator.validationEventDecorator);
            for (ValidationEvent event : result.getValidationEvents()) {
                if (this.validationEventDecorator.canDecorate(event)) {
                    event = this.validationEventDecorator.decorate(event);
                }
                this.events.add(event);
            }
            for (ValidationEvent event : validator.events) {
                this.pushEvent(event);
            }
            this.loadModelValidators(validator.validatorFactory);
        }

        private void loadModelValidators(ValidatorFactory validatorFactory) {
            ValidatedResult<List<ValidatorDefinition>> loaded = ValidationLoader.loadValidators(this.model.getMetadata());
            this.pushEvents(loaded.getValidationEvents());
            List definitions = loaded.getResult().orElseGet(Collections::emptyList);
            ValidatorFromDefinitionFactory factory = new ValidatorFromDefinitionFactory(validatorFactory);
            for (ValidatorDefinition val : definitions) {
                ValidatedResult<Validator> result = factory.loadValidator(val);
                result.getResult().ifPresent(this.validators::add);
                this.pushEvents(result.getValidationEvents());
                if (!result.getValidationEvents().isEmpty() || result.getResult().isPresent()) continue;
                ValidationEvent event = LoadedModelValidator.unknownValidatorError(val.name, val.sourceLocation);
                this.pushEvent(event);
            }
        }

        private static ValidationEvent unknownValidatorError(String name, SourceLocation location) {
            return ValidationEvent.builder().id("UnknownValidator_" + name).severity(Severity.WARNING).sourceLocation(location).message("Unable to locate a validator named `" + name + "`").build();
        }

        private void pushEvents(List<ValidationEvent> source) {
            for (ValidationEvent event : source) {
                this.pushEvent(event);
            }
        }

        private void pushEvent(ValidationEvent event) {
            if (this.validationEventDecorator.canDecorate(event)) {
                event = this.validationEventDecorator.decorate(event);
            }
            this.events.add(event);
            this.eventListener.accept(event);
        }

        private List<ValidationEvent> validate() {
            this.pushEvents(new TargetValidator().validate(this.model));
            this.pushEvents(new ResourceCycleValidator().validate(this.model));
            if (LoaderUtils.containsErrorEvents(this.events)) {
                return this.events;
            }
            List<ValidationEvent> result = this.validators.parallelStream().flatMap(validator -> validator.validate(this.model).stream()).filter(this::filterPrelude).map(e -> this.validationEventDecorator.canDecorate((ValidationEvent)e) ? this.validationEventDecorator.decorate((ValidationEvent)e) : e).peek(this.eventListener).collect(Collectors.toList());
            result.addAll(this.events);
            return result;
        }

        private boolean filterPrelude(ValidationEvent event) {
            return event.getSeverity() == Severity.ERROR || !event.getShapeId().filter(Prelude::isPreludeShape).isPresent();
        }
    }

    private static final class LazyValidatorFactoryHolder {
        static final ValidatorFactory INSTANCE = ValidatorFactory.createServiceFactory(ModelAssembler.class.getClassLoader());

        private LazyValidatorFactoryHolder() {
        }
    }
}

