/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.Arrays;
import java.util.function.Function;

public final class StringTable
implements Function<CharSequence, String> {
    private static final int FNV_OFFSET_BIAS = -2128831035;
    private static final int FNV_PRIME = 16777619;
    private final String[] table;
    private final int sizeBits;
    private final int size;
    private final int sizeMask;

    public StringTable() {
        this(11);
    }

    public StringTable(int sizeBits) {
        if (sizeBits <= 0) {
            throw new IllegalArgumentException("Cache sizeBits must be >= 1");
        }
        if (sizeBits >= 17) {
            throw new IllegalArgumentException("Refusing to create a cache with 131072 entries");
        }
        this.sizeBits = sizeBits;
        this.size = 1 << sizeBits;
        this.sizeMask = this.size - 1;
        this.table = new String[this.size];
        Arrays.fill(this.table, "");
    }

    @Override
    public String apply(CharSequence chars) {
        String value;
        String[] arr = this.table;
        int idx = this.localIdxFromHash(chars);
        String text = arr[idx];
        if (StringTable.textEquals(chars, text)) {
            return text;
        }
        arr[idx] = value = chars.toString();
        return value;
    }

    private int localIdxFromHash(CharSequence chars) {
        return StringTable.getFnvHashCode(chars) & this.sizeMask;
    }

    private static int getFnvHashCode(CharSequence text) {
        int hashCode = -2128831035;
        int end = text.length();
        for (int i = 0; i < end; ++i) {
            hashCode = (hashCode ^ text.charAt(i)) * 16777619;
        }
        return hashCode;
    }

    private static boolean textEquals(CharSequence left, String right) {
        if (left.length() != right.length()) {
            return false;
        }
        for (int i = 0; i < left.length(); ++i) {
            if (left.charAt(i) == right.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

