/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NeighborProviderIndex;
import software.amazon.smithy.model.neighbor.NeighborProvider;
import software.amazon.smithy.model.neighbor.Relationship;
import software.amazon.smithy.model.neighbor.RelationshipType;
import software.amazon.smithy.model.node.ExpectationNotMetException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.traits.DefaultTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.NodeValidationVisitor;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class DefaultTraitValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        NodeValidationVisitor visitor = null;
        NeighborProvider reverse = NeighborProviderIndex.of(model).getReverseProvider();
        for (Shape shape : model.getShapesWithTrait(DefaultTrait.class)) {
            DefaultTrait trait = shape.expectTrait(DefaultTrait.class);
            visitor = this.validateShapeValue(model, shape, trait, visitor, events);
            Node value = trait.toNode();
            if (shape.isMemberShape()) continue;
            for (Relationship rel : reverse.getNeighbors(shape)) {
                MemberShape member;
                if (rel.getRelationshipType() != RelationshipType.MEMBER_TARGET || model.expectShape((member = rel.getShape().asMemberShape().orElseThrow(() -> new ExpectationNotMetException("Expected shape to be a member", rel.getShape()))).getContainer()).getType() != ShapeType.STRUCTURE) continue;
                DefaultTrait memberDefault = member.getTrait(DefaultTrait.class).orElse(null);
                if (memberDefault == null) {
                    events.add(this.error(member, String.format("Member targets %s, which requires that the member defines the same default of `%s` or `null`", shape.toShapeId(), Node.printJson(value))));
                    continue;
                }
                if (memberDefault.toNode().isNullNode() || value.equals(member.expectTrait(DefaultTrait.class).toNode())) continue;
                events.add(this.error(member, String.format("Member defines a default value that differs from the default value of the target shape, %s. The member has a default of `%s`, but the target has a default of `%s`.", shape.toShapeId(), member.expectTrait(DefaultTrait.class).toNode(), Node.printJson(value))));
            }
        }
        return events;
    }

    private NodeValidationVisitor validateShapeValue(Model model, Shape shape, DefaultTrait trait, NodeValidationVisitor visitor, List<ValidationEvent> events) {
        Node value = trait.toNode();
        Shape shapeTarget = shape;
        if (shape.isMemberShape()) {
            shapeTarget = model.expectShape(shape.asMemberShape().get().getTarget());
            if (value.isNullNode()) {
                return visitor;
            }
        } else if (value.isNullNode()) {
            events.add(this.error(shape, trait, "The @default trait can be set to null only on members"));
            return visitor;
        }
        visitor = this.createOrReuseVisitor(model, visitor, value, shape);
        events.addAll((Collection<ValidationEvent>)shape.accept(visitor));
        switch (shapeTarget.getType()) {
            case MAP: {
                value.asObjectNode().ifPresent(obj -> {
                    if (!obj.isEmpty()) {
                        events.add(this.error(shape, trait, "The @default value of a map must be an empty map"));
                    }
                });
                break;
            }
            case LIST: 
            case SET: {
                value.asArrayNode().ifPresent(array -> {
                    if (!array.isEmpty()) {
                        events.add(this.error(shape, trait, "The @default value of a list must be an empty list"));
                    }
                });
                break;
            }
            case DOCUMENT: {
                value.asArrayNode().ifPresent(array -> {
                    if (!array.isEmpty()) {
                        events.add(this.error(shape, trait, "The @default value of a document cannot be a non-empty array"));
                    }
                });
                value.asObjectNode().ifPresent(obj -> {
                    if (!obj.isEmpty()) {
                        events.add(this.error(shape, trait, "The @default value of a document cannot be a non-empty object"));
                    }
                });
                break;
            }
        }
        return visitor;
    }

    private NodeValidationVisitor createOrReuseVisitor(Model model, NodeValidationVisitor visitor, Node value, Shape shape) {
        if (visitor == null) {
            return NodeValidationVisitor.builder().model(model).eventId(this.getName()).value(value).startingContext("Error validating @default trait").eventShapeId(shape.getId()).addFeature(NodeValidationVisitor.Feature.RANGE_TRAIT_ZERO_VALUE_WARNING).build();
        }
        visitor.setValue(value);
        visitor.setEventShapeId(shape.getId());
        return visitor;
    }
}

