/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NeighborProviderIndex;
import software.amazon.smithy.model.selector.AndSelector;
import software.amazon.smithy.model.selector.Context;
import software.amazon.smithy.model.selector.InternalSelector;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.Shape;

final class WrappedSelector
implements Selector {
    private static final int PARALLEL_THRESHOLD = 10000;
    private final String expression;
    private final InternalSelector delegate;
    private final List<InternalSelector> roots;

    WrappedSelector(String expression, List<InternalSelector> selectors, List<InternalSelector> roots) {
        this.expression = expression;
        this.roots = roots;
        this.delegate = AndSelector.of(selectors);
    }

    public String toString() {
        return this.expression;
    }

    public boolean equals(Object other) {
        return other instanceof Selector && this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    @Override
    public Set<Shape> select(Model model) {
        if (this.isParallel(model)) {
            return this.shapes(model).collect(Collectors.toSet());
        }
        HashSet<Shape> result = new HashSet<Shape>();
        this.pushShapes(model, (ctx, s) -> {
            result.add(s);
            return InternalSelector.Response.CONTINUE;
        });
        return result;
    }

    @Override
    public void consumeMatches(Model model, Consumer<Selector.ShapeMatch> shapeMatchConsumer) {
        this.pushShapes(model, (ctx, s) -> {
            shapeMatchConsumer.accept(new Selector.ShapeMatch(s, ctx.getVars()));
            return InternalSelector.Response.CONTINUE;
        });
    }

    @Override
    public Stream<Shape> shapes(Model model) {
        NeighborProviderIndex index = NeighborProviderIndex.of(model);
        List<Set<Shape>> computedRoots = this.computeRoots(model);
        return this.streamStartingShape(model).flatMap(shape -> {
            Context context = new Context(model, index, computedRoots);
            return this.delegate.pushResultsToCollection(context, (Shape)shape, new ArrayList()).stream();
        });
    }

    @Override
    public Stream<Selector.ShapeMatch> matches(Model model) {
        NeighborProviderIndex index = NeighborProviderIndex.of(model);
        List<Set<Shape>> computedRoots = this.computeRoots(model);
        return this.streamStartingShape(model).flatMap(shape -> {
            ArrayList result = new ArrayList();
            this.delegate.push(new Context(model, index, computedRoots), (Shape)shape, (ctx, s) -> {
                result.add(new Selector.ShapeMatch(s, ctx.getVars()));
                return InternalSelector.Response.CONTINUE;
            });
            return result.stream();
        });
    }

    private List<Set<Shape>> computeRoots(Model model) {
        NeighborProviderIndex index = NeighborProviderIndex.of(model);
        ArrayList<Set<Shape>> rootResults = new ArrayList<Set<Shape>>(this.roots.size());
        for (InternalSelector selector : this.roots) {
            Set<Shape> result = this.evalRoot(model, index, selector, rootResults);
            rootResults.add(result);
        }
        return rootResults;
    }

    private Set<Shape> evalRoot(Model model, NeighborProviderIndex index, InternalSelector selector, List<Set<Shape>> results) {
        Collection<? extends Shape> shapesToEmit = selector.getStartingShapes(model);
        Context isolatedContext = new Context(model, index, results);
        HashSet<Shape> captures = new HashSet<Shape>();
        for (Shape shape : shapesToEmit) {
            isolatedContext.getVars().clear();
            selector.push(isolatedContext, shape, (c, s) -> {
                captures.add(s);
                return InternalSelector.Response.CONTINUE;
            });
        }
        return captures;
    }

    private void pushShapes(Model model, InternalSelector.Receiver acceptor) {
        Context context = new Context(model, NeighborProviderIndex.of(model), this.computeRoots(model));
        Collection<? extends Shape> shapes = this.delegate.getStartingShapes(model);
        for (Shape shape : shapes) {
            context.getVars().clear();
            this.delegate.push(context, shape, acceptor);
        }
    }

    private Stream<? extends Shape> streamStartingShape(Model model) {
        Collection<? extends Shape> startingShapes = this.delegate.getStartingShapes(model);
        return startingShapes.size() > 10000 ? startingShapes.parallelStream() : startingShapes.stream();
    }

    private boolean isParallel(Model model) {
        return model.getShapeIds().size() >= 10000;
    }
}

