/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.knowledge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.node.ExpectationNotMetException;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.InputTrait;
import software.amazon.smithy.model.traits.OutputTrait;
import software.amazon.smithy.model.traits.UnitTypeTrait;
import software.amazon.smithy.utils.ListUtils;

public final class OperationIndex
implements KnowledgeIndex {
    private final Map<ShapeId, StructureShape> inputs = new HashMap<ShapeId, StructureShape>();
    private final Map<ShapeId, StructureShape> outputs = new HashMap<ShapeId, StructureShape>();
    private final Map<ShapeId, List<StructureShape>> errors = new HashMap<ShapeId, List<StructureShape>>();

    public OperationIndex(Model model) {
        for (OperationShape operation : model.getOperationShapes()) {
            this.getStructure(model, operation.getInputShape()).ifPresent(shape -> this.inputs.put(operation.getId(), (StructureShape)shape));
            this.getStructure(model, operation.getOutputShape()).ifPresent(shape -> this.outputs.put(operation.getId(), (StructureShape)shape));
            this.addErrorsFromShape(model, operation.getId(), operation.getErrors());
        }
        for (ServiceShape service : model.getServiceShapes()) {
            this.addErrorsFromShape(model, service.getId(), service.getErrors());
        }
    }

    private void addErrorsFromShape(Model model, ShapeId source, List<ShapeId> errorShapeIds) {
        ArrayList errorShapes = new ArrayList(errorShapeIds.size());
        for (ShapeId target : errorShapeIds) {
            model.getShape(target).flatMap(Shape::asStructureShape).ifPresent(errorShapes::add);
        }
        this.errors.put(source, errorShapes);
    }

    public static OperationIndex of(Model model) {
        return model.getKnowledge(OperationIndex.class, OperationIndex::new);
    }

    public Optional<StructureShape> getInput(ToShapeId operation) {
        return this.getInputShape(operation).filter(shape -> !shape.getId().equals(UnitTypeTrait.UNIT));
    }

    public Optional<StructureShape> getInputShape(ToShapeId operation) {
        return Optional.ofNullable(this.inputs.get(operation.toShapeId()));
    }

    public StructureShape expectInputShape(ToShapeId operation) {
        return this.getInputShape(operation).orElseThrow(() -> new ExpectationNotMetException("Cannot get the input of `" + operation.toShapeId() + "` because it is not an operation shape in the model.", SourceLocation.NONE));
    }

    public Map<String, MemberShape> getInputMembers(ToShapeId operation) {
        return this.getInputShape(operation).map(input -> input.getAllMembers()).orElse(Collections.emptyMap());
    }

    public boolean isInputStructure(ToShapeId structureId) {
        if (structureId instanceof Shape && ((Shape)structureId).hasTrait(InputTrait.class)) {
            return true;
        }
        ShapeId id = structureId.toShapeId();
        for (StructureShape shape : this.inputs.values()) {
            if (!shape.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public Optional<StructureShape> getOutput(ToShapeId operation) {
        return this.getOutputShape(operation).filter(shape -> !shape.getId().equals(UnitTypeTrait.UNIT));
    }

    public Optional<StructureShape> getOutputShape(ToShapeId operation) {
        return Optional.ofNullable(this.outputs.get(operation.toShapeId()));
    }

    public StructureShape expectOutputShape(ToShapeId operation) {
        return this.getOutputShape(operation).orElseThrow(() -> new ExpectationNotMetException("Cannot get the output of `" + operation.toShapeId() + "` because it is not an operation shape in the model.", SourceLocation.NONE));
    }

    public Map<String, MemberShape> getOutputMembers(ToShapeId operation) {
        return this.getOutputShape(operation).map(output -> output.getAllMembers()).orElse(Collections.emptyMap());
    }

    public boolean isOutputStructure(ToShapeId structureId) {
        if (structureId instanceof Shape && ((Shape)structureId).hasTrait(OutputTrait.class)) {
            return true;
        }
        ShapeId id = structureId.toShapeId();
        for (StructureShape shape : this.outputs.values()) {
            if (!shape.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public List<StructureShape> getErrors(ToShapeId operation) {
        return this.errors.getOrDefault(operation.toShapeId(), ListUtils.of());
    }

    public List<StructureShape> getErrors(ToShapeId service, ToShapeId operation) {
        LinkedHashSet<StructureShape> result = new LinkedHashSet<StructureShape>(this.getErrors(service));
        result.addAll(this.getErrors(operation));
        return new ArrayList<StructureShape>(result);
    }

    private Optional<StructureShape> getStructure(Model model, ToShapeId id) {
        return model.getShape(id.toShapeId()).flatMap(Shape::asStructureShape);
    }
}

