/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.ArrayList;
import java.util.List;

final class IdlStringLexer {
    private IdlStringLexer() {
    }

    static CharSequence scanStringContents(CharSequence lexeme, boolean scanningTextBlock) {
        lexeme = IdlStringLexer.normalizeLineEndings(lexeme);
        if (scanningTextBlock) {
            lexeme = IdlStringLexer.formatTextBlock(lexeme);
        }
        StringBuilderProxy result = new StringBuilderProxy(lexeme);
        State state = State.NORMAL;
        int hexCount = 0;
        int unicode = 0;
        block17: for (int i = 0; i < lexeme.length(); ++i) {
            char c = lexeme.charAt(i);
            switch (state) {
                case NORMAL: {
                    if (c == '\\') {
                        state = State.AFTER_ESCAPE;
                        result.capture();
                        continue block17;
                    }
                    if (IdlStringLexer.isValidNormalCharacter(c, scanningTextBlock)) {
                        result.append(c);
                        continue block17;
                    }
                    throw new RuntimeException("Invalid string character: `" + c + "`");
                }
                case AFTER_ESCAPE: {
                    state = State.NORMAL;
                    switch (c) {
                        case '\"': {
                            result.append('\"');
                            continue block17;
                        }
                        case '\\': {
                            result.append('\\');
                            continue block17;
                        }
                        case '/': {
                            result.append('/');
                            continue block17;
                        }
                        case 'b': {
                            result.append('\b');
                            continue block17;
                        }
                        case 'f': {
                            result.append('\f');
                            continue block17;
                        }
                        case 'n': {
                            result.append('\n');
                            continue block17;
                        }
                        case 'r': {
                            result.append('\r');
                            continue block17;
                        }
                        case 't': {
                            result.append('\t');
                            continue block17;
                        }
                        case 'u': {
                            state = State.UNICODE;
                            continue block17;
                        }
                        case '\n': {
                            continue block17;
                        }
                    }
                    throw new RuntimeException("Invalid escape found in string: `\\" + c + "`");
                }
                case UNICODE: {
                    if (c >= '0' && c <= '9') {
                        unicode = unicode << 4 | c - 48;
                    } else if (c >= 'a' && c <= 'f') {
                        unicode = unicode << 4 | 10 + c - 97;
                    } else if (c >= 'A' && c <= 'F') {
                        unicode = unicode << 4 | 10 + c - 65;
                    } else {
                        throw new RuntimeException("Invalid unicode escape character: `" + c + "`");
                    }
                    if (++hexCount != 4) continue block17;
                    result.append((char)unicode);
                    hexCount = 0;
                    state = State.NORMAL;
                    continue block17;
                }
                default: {
                    throw new IllegalStateException("Unreachable");
                }
            }
        }
        if (state == State.UNICODE) {
            throw new RuntimeException("Invalid unclosed unicode escape found in string");
        }
        return result.getResult();
    }

    private static CharSequence normalizeLineEndings(CharSequence lexeme) {
        if (!IdlStringLexer.containsCarriageReturn(lexeme)) {
            return lexeme;
        }
        StringBuilder builder = new StringBuilder(lexeme.length());
        for (int i = 0; i < lexeme.length(); ++i) {
            char c = lexeme.charAt(i);
            if (c != '\r') {
                builder.append(c);
                continue;
            }
            if (i < lexeme.length() - 1 && lexeme.charAt(i + 1) == '\n') {
                ++i;
            }
            builder.append('\n');
        }
        return builder;
    }

    private static boolean containsCarriageReturn(CharSequence lexeme) {
        for (int i = 0; i < lexeme.length(); ++i) {
            if (lexeme.charAt(i) != '\r') continue;
            return true;
        }
        return false;
    }

    private static CharSequence formatTextBlock(CharSequence lexeme) {
        int i;
        if (lexeme.length() == 0) {
            throw new RuntimeException("Text block is empty");
        }
        if (lexeme.charAt(0) != '\n') {
            throw new RuntimeException("Text block must start with a new line");
        }
        StringBuilder buffer = new StringBuilder();
        int longestPadding = Integer.MAX_VALUE;
        List<CharSequence> lines = IdlStringLexer.lines(lexeme);
        for (i = 1; i < lines.size(); ++i) {
            int padding = IdlStringLexer.computeLeadingWhitespace(lines.get(i), i == lines.size() - 1);
            if (padding <= -1 || padding >= longestPadding) continue;
            longestPadding = padding;
        }
        for (i = 1; i < lines.size(); ++i) {
            CharSequence formattedLine;
            CharSequence line = lines.get(i);
            if (line.length() > 0 && (formattedLine = IdlStringLexer.createTextBlockLine(line, longestPadding)) != null) {
                buffer.append(formattedLine);
            }
            if (i >= lines.size() - 1) continue;
            buffer.append('\n');
        }
        return buffer;
    }

    private static List<CharSequence> lines(CharSequence text) {
        ArrayList<CharSequence> lines = new ArrayList<CharSequence>();
        int mark = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '\n') continue;
            lines.add(text.subSequence(mark, i));
            mark = i + 1;
        }
        lines.add(text.subSequence(mark, text.length()));
        return lines;
    }

    private static int computeLeadingWhitespace(CharSequence line, boolean isLastLine) {
        if (line.length() == 0) {
            return -1;
        }
        for (int offset = 0; offset < line.length(); ++offset) {
            if (line.charAt(offset) == ' ') continue;
            return offset;
        }
        return isLastLine ? line.length() : -1;
    }

    private static CharSequence createTextBlockLine(CharSequence line, int longestPadding) {
        int endPosition;
        int startPosition = Math.min(longestPadding, line.length());
        for (endPosition = line.length() - 1; endPosition > 0 && line.charAt(endPosition) == ' '; --endPosition) {
        }
        return endPosition >= startPosition ? line.subSequence(startPosition, endPosition + 1) : null;
    }

    private static boolean isValidNormalCharacter(char c, boolean isTextBlock) {
        return c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '!' || isTextBlock && c == '\"' || c >= '#' && c <= '[' || c >= ']';
    }

    private static final class StringBuilderProxy {
        private final CharSequence lexeme;
        private StringBuilder builder;
        private int position = 0;

        StringBuilderProxy(CharSequence lexeme) {
            this.lexeme = lexeme;
        }

        void capture() {
            if (this.builder == null) {
                this.builder = new StringBuilder(this.lexeme.length());
                this.builder.append(this.lexeme, 0, this.position);
            }
        }

        void append(char c) {
            if (this.builder != null) {
                this.builder.append(c);
            } else {
                ++this.position;
            }
        }

        CharSequence getResult() {
            return this.builder == null ? this.lexeme : this.builder;
        }
    }

    private static enum State {
        NORMAL,
        AFTER_ESCAPE,
        UNICODE;

    }
}

