/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import software.amazon.smithy.model.selector.AttributeComparator;
import software.amazon.smithy.model.selector.AttributeValue;
import software.amazon.smithy.model.selector.Context;
import software.amazon.smithy.model.selector.InternalSelector;
import software.amazon.smithy.model.shapes.Shape;

final class AttributeSelector
implements InternalSelector {
    private final BiFunction<Shape, Map<String, Set<Shape>>, AttributeValue> key;
    private final List<AttributeValue> expected;
    private final AttributeComparator comparator;
    private final boolean caseInsensitive;

    AttributeSelector(BiFunction<Shape, Map<String, Set<Shape>>, AttributeValue> key, List<String> expected, AttributeComparator comparator, boolean caseInsensitive) {
        this.key = key;
        this.caseInsensitive = caseInsensitive;
        this.comparator = comparator;
        if (expected == null) {
            this.expected = Collections.emptyList();
        } else {
            this.expected = new ArrayList<AttributeValue>(expected.size());
            for (String validValue : expected) {
                this.expected.add(AttributeValue.literal(validValue));
            }
        }
    }

    static AttributeSelector existence(BiFunction<Shape, Map<String, Set<Shape>>, AttributeValue> key) {
        return new AttributeSelector(key, null, null, false);
    }

    @Override
    public boolean push(Context context, Shape shape, InternalSelector.Receiver next) {
        if (this.matchesAttribute(shape, context)) {
            return next.apply(context, shape);
        }
        return true;
    }

    private boolean matchesAttribute(Shape shape, Context stack) {
        AttributeValue lhs = this.key.apply(shape, stack.getVars());
        if (this.expected.isEmpty()) {
            return lhs.isPresent();
        }
        for (AttributeValue rhs : this.expected) {
            if (!this.comparator.compare(lhs, rhs, this.caseInsensitive)) continue;
            return true;
        }
        return false;
    }
}

