/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.IdlInternalTokenizer;
import software.amazon.smithy.model.loader.IdlModelLoader;
import software.amazon.smithy.model.loader.IdlNodeParser;
import software.amazon.smithy.model.loader.IdlShapeIdParser;
import software.amazon.smithy.model.loader.IdlToken;
import software.amazon.smithy.model.loader.ModelSyntaxException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NullNode;
import software.amazon.smithy.model.node.NumberNode;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.traits.DocumentationTrait;

final class IdlTraitParser {
    private IdlTraitParser() {
    }

    static List<Result> parseDocsAndTraitsBeforeShape(IdlModelLoader loader) {
        IdlInternalTokenizer tokenizer = loader.getTokenizer();
        tokenizer.skipWs();
        Result docComment = null;
        if (tokenizer.getCurrentToken() == IdlToken.DOC_COMMENT) {
            SourceLocation documentationLocation = tokenizer.getCurrentTokenLocation();
            tokenizer.skipWsAndDocs();
            docComment = IdlTraitParser.parseDocComment(tokenizer, documentationLocation);
        } else {
            tokenizer.skipWsAndDocs();
        }
        tokenizer.skipWsAndDocs();
        List<Result> traits = IdlTraitParser.expectAndSkipTraits(loader);
        if (docComment != null) {
            traits.add(docComment);
        }
        tokenizer.skipWsAndDocs();
        return traits;
    }

    private static Result parseDocComment(IdlInternalTokenizer tokenizer, SourceLocation location) {
        String result = tokenizer.removePendingDocCommentLines();
        if (result == null) {
            return null;
        }
        StringNode value = new StringNode(result, location);
        return new Result(DocumentationTrait.ID.toString(), value, TraitType.DOC_COMMENT);
    }

    static List<Result> expectAndSkipTraits(IdlModelLoader loader) {
        ArrayList<Result> results = new ArrayList<Result>();
        IdlInternalTokenizer tokenizer = loader.getTokenizer();
        while (tokenizer.getCurrentToken() == IdlToken.AT) {
            results.add(IdlTraitParser.expectAndSkipTrait(loader));
            tokenizer.skipWsAndDocs();
        }
        return results;
    }

    static Result expectAndSkipTrait(IdlModelLoader loader) {
        IdlInternalTokenizer tokenizer = loader.getTokenizer();
        SourceLocation location = tokenizer.getCurrentTokenLocation();
        tokenizer.expect(IdlToken.AT);
        tokenizer.next();
        CharSequence id = IdlShapeIdParser.expectAndSkipShapeId(tokenizer);
        if (tokenizer.getCurrentToken() != IdlToken.LPAREN) {
            return new Result(id, new NullNode(location), TraitType.ANNOTATION);
        }
        tokenizer.next();
        tokenizer.skipWsAndDocs();
        if (tokenizer.getCurrentToken() == IdlToken.RPAREN) {
            tokenizer.next();
            return new Result(id, new NullNode(location), TraitType.ANNOTATION);
        }
        Node value = IdlTraitParser.parseTraitValueBody(loader, location);
        tokenizer.skipWsAndDocs();
        tokenizer.expect(IdlToken.RPAREN);
        tokenizer.next();
        return new Result(id, value, TraitType.VALUE);
    }

    private static Node parseTraitValueBody(IdlModelLoader loader, SourceLocation location) {
        IdlInternalTokenizer tokenizer = loader.getTokenizer();
        tokenizer.expect(IdlToken.LBRACE, IdlToken.LBRACKET, IdlToken.TEXT_BLOCK, IdlToken.STRING, IdlToken.NUMBER, IdlToken.IDENTIFIER);
        switch (tokenizer.getCurrentToken()) {
            case LBRACE: 
            case LBRACKET: {
                Node result = IdlNodeParser.expectAndSkipNode(loader, location);
                tokenizer.skipWsAndDocs();
                return result;
            }
            case TEXT_BLOCK: {
                StringNode textBlockResult = new StringNode(tokenizer.getCurrentTokenStringSlice().toString(), location);
                tokenizer.next();
                tokenizer.skipWsAndDocs();
                return textBlockResult;
            }
            case NUMBER: {
                Number number = tokenizer.getCurrentTokenNumberValue();
                tokenizer.next();
                tokenizer.skipWsAndDocs();
                return new NumberNode(number, location);
            }
            case STRING: {
                String stringValue = tokenizer.getCurrentTokenStringSlice().toString();
                StringNode stringNode = new StringNode(stringValue, location);
                tokenizer.next();
                tokenizer.skipWsAndDocs();
                if (tokenizer.getCurrentToken() == IdlToken.COLON) {
                    tokenizer.next();
                    tokenizer.skipWsAndDocs();
                    return IdlTraitParser.parseStructuredTrait(loader, stringNode);
                }
                return stringNode;
            }
        }
        String identifier = loader.internString(tokenizer.getCurrentTokenLexeme());
        tokenizer.next();
        tokenizer.skipWsAndDocs();
        if (tokenizer.getCurrentToken() == IdlToken.COLON) {
            tokenizer.next();
            tokenizer.skipWsAndDocs();
            return IdlTraitParser.parseStructuredTrait(loader, new StringNode(identifier, location));
        }
        return IdlNodeParser.parseIdentifier(loader, identifier, location);
    }

    private static ObjectNode parseStructuredTrait(IdlModelLoader loader, StringNode firstKey) {
        IdlInternalTokenizer tokenizer = loader.getTokenizer();
        loader.increaseNestingLevel();
        LinkedHashMap<StringNode, Node> entries = new LinkedHashMap<StringNode, Node>();
        Node firstValue = IdlNodeParser.expectAndSkipNode(loader);
        entries.put(firstKey, firstValue);
        tokenizer.skipWsAndDocs();
        while (tokenizer.getCurrentToken() != IdlToken.RPAREN) {
            tokenizer.expect(IdlToken.IDENTIFIER, IdlToken.STRING);
            String key = loader.internString(tokenizer.getCurrentTokenStringSlice());
            StringNode keyNode = new StringNode(key, tokenizer.getCurrentTokenLocation());
            tokenizer.next();
            tokenizer.skipWsAndDocs();
            tokenizer.expect(IdlToken.COLON);
            tokenizer.next();
            tokenizer.skipWsAndDocs();
            Node nextValue = IdlNodeParser.expectAndSkipNode(loader);
            Node previous = entries.put(keyNode, nextValue);
            if (previous != null) {
                throw new ModelSyntaxException("Duplicate member of trait: '" + keyNode.getValue() + '\'', keyNode);
            }
            tokenizer.skipWsAndDocs();
        }
        loader.decreaseNestingLevel();
        return new ObjectNode(entries, firstKey.getSourceLocation());
    }

    static final class Result {
        private final CharSequence traitName;
        private final Node value;
        private final TraitType traitType;

        Result(CharSequence traitName, Node value, TraitType traitType) {
            this.traitName = traitName;
            this.value = value;
            this.traitType = traitType;
        }

        CharSequence getTraitName() {
            return this.traitName;
        }

        Node getValue() {
            return this.value;
        }

        TraitType getTraitType() {
            return this.traitType;
        }
    }

    static enum TraitType {
        VALUE,
        ANNOTATION,
        DOC_COMMENT;

    }
}

