/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation;

import java.util.List;
import software.amazon.smithy.model.validation.ValidationEvent;

public interface ValidationEventDecorator {
    public boolean canDecorate(ValidationEvent var1);

    public ValidationEvent decorate(ValidationEvent var1);

    public static ValidationEventDecorator compose(final List<ValidationEventDecorator> decorators) {
        if (decorators.isEmpty()) {
            return new ValidationEventDecorator(){

                @Override
                public boolean canDecorate(ValidationEvent ev) {
                    return false;
                }

                @Override
                public ValidationEvent decorate(ValidationEvent ev) {
                    return ev;
                }
            };
        }
        return new ValidationEventDecorator(){

            @Override
            public boolean canDecorate(ValidationEvent ev) {
                for (ValidationEventDecorator decorator : decorators) {
                    if (!decorator.canDecorate(ev)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public ValidationEvent decorate(ValidationEvent ev) {
                ValidationEvent decoratedEvent = ev;
                for (ValidationEventDecorator decorator : decorators) {
                    if (!decorator.canDecorate(ev)) continue;
                    decoratedEvent = decorator.decorate(decoratedEvent);
                }
                return decoratedEvent;
            }
        };
    }
}

