/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import software.amazon.smithy.model.neighbor.NeighborProvider;
import software.amazon.smithy.model.neighbor.Relationship;
import software.amazon.smithy.model.neighbor.RelationshipType;
import software.amazon.smithy.model.selector.Context;
import software.amazon.smithy.model.selector.InternalSelector;
import software.amazon.smithy.model.shapes.Shape;

final class NeighborSelector
implements InternalSelector {
    private static final NeighborSelector FORWARD = new NeighborSelector(Collections.emptyList(), Direction.FORWARD);
    private static final NeighborSelector REVERSE = new NeighborSelector(Collections.emptyList(), Direction.REVERSE);
    private final List<String> relTypes;
    private final Direction direction;
    private final Function<Context, NeighborProvider> neighborFactory;

    private NeighborSelector(List<String> relTypes, Direction direction) {
        this.relTypes = Objects.requireNonNull(relTypes);
        this.direction = direction;
        boolean includeTraits = relTypes.contains("trait");
        this.neighborFactory = direction.neighborFactory(includeTraits);
    }

    static NeighborSelector forward(List<String> relTypes) {
        return relTypes.isEmpty() ? FORWARD : new NeighborSelector(relTypes, Direction.FORWARD);
    }

    static NeighborSelector reverse(List<String> relTypes) {
        return relTypes.isEmpty() ? REVERSE : new NeighborSelector(relTypes, Direction.REVERSE);
    }

    @Override
    public InternalSelector.Response push(Context context, Shape shape, InternalSelector.Receiver next) {
        NeighborProvider resolvedProvider = this.neighborFactory.apply(context);
        for (Relationship rel : resolvedProvider.getNeighbors(shape)) {
            if (!this.matches(rel) || this.direction.emit(context, rel, next) != InternalSelector.Response.STOP) continue;
            return InternalSelector.Response.STOP;
        }
        return InternalSelector.Response.CONTINUE;
    }

    private boolean matches(Relationship rel) {
        return rel.getRelationshipType() != RelationshipType.MEMBER_CONTAINER && rel.getNeighborShape().isPresent() && NeighborSelector.relTypesMatchesRel(this.relTypes, rel);
    }

    private static boolean relTypesMatchesRel(List<String> relTypes, Relationship rel) {
        if (relTypes.isEmpty()) {
            return true;
        }
        String relType = rel.getSelectorLabel().orElse("");
        return relTypes.contains(relType);
    }

    private static enum Direction {
        FORWARD{

            @Override
            InternalSelector.Response emit(Context context, Relationship rel, InternalSelector.Receiver next) {
                return next.apply(context, rel.getNeighborShape().get());
            }

            @Override
            Function<Context, NeighborProvider> neighborFactory(boolean includeTraits) {
                return includeTraits ? context -> context.neighborIndex.getProviderWithTraitRelationships() : context -> context.neighborIndex.getProvider();
            }
        }
        ,
        REVERSE{

            @Override
            InternalSelector.Response emit(Context context, Relationship rel, InternalSelector.Receiver next) {
                return next.apply(context, rel.getShape());
            }

            @Override
            Function<Context, NeighborProvider> neighborFactory(boolean includeTraits) {
                return includeTraits ? context -> context.neighborIndex.getReverseProviderWithTraitRelationships() : context -> context.neighborIndex.getReverseProvider();
            }
        };


        abstract InternalSelector.Response emit(Context var1, Relationship var2, InternalSelector.Receiver var3);

        abstract Function<Context, NeighborProvider> neighborFactory(boolean var1);
    }
}

