/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import software.amazon.smithy.model.loader.ModelImportException;
import software.amazon.smithy.model.loader.ModelManifestException;

public final class ModelDiscovery {
    private static final Logger LOGGER = Logger.getLogger(ModelDiscovery.class.getName());
    private static final String ROOT_RESOURCE_PATH = "META-INF/smithy/";
    private static final String MANIFEST = "manifest";
    private static final String MANIFEST_PATH = "META-INF/smithy/manifest";
    private static final Pattern PROHIBITED_RESOURCE_SEGMENT_CHARS = Pattern.compile("[\t\\\\?%*:|\"'><# ]+");

    private ModelDiscovery() {
    }

    public static List<URL> findModels() {
        return ModelDiscovery.findModels(Thread.currentThread().getContextClassLoader());
    }

    public static List<URL> findModels(ClassLoader loader) {
        try {
            ArrayList<URL> result = new ArrayList<URL>();
            Enumeration<URL> manifests = loader.getResources(MANIFEST_PATH);
            while (manifests.hasMoreElements()) {
                result.addAll(ModelDiscovery.findModels(manifests.nextElement()));
            }
            return result;
        }
        catch (IOException e) {
            throw new ModelManifestException("Error locating Smithy model manifests", e);
        }
    }

    public static List<URL> findModels(URL jarManifestUrl) {
        ArrayList<URL> result = new ArrayList<URL>();
        LOGGER.finer(() -> "Found ModelDiscovery manifest at " + jarManifestUrl);
        String modelUrlPrefix = jarManifestUrl.toString();
        modelUrlPrefix = modelUrlPrefix.substring(0, modelUrlPrefix.length() - MANIFEST.length());
        try {
            for (String model : ModelDiscovery.parseManifest(jarManifestUrl)) {
                URL modelUrl = new URL(modelUrlPrefix + model);
                LOGGER.finest(() -> String.format("Found Smithy model `%s` in manifest", modelUrl));
                result.add(modelUrl);
            }
        }
        catch (IOException e) {
            throw new ModelManifestException("Error parsing Smithy model manifest from " + jarManifestUrl, e);
        }
        return result;
    }

    public static String getSmithyModelPathFromJarUrl(URL modelUrl) {
        String urlString = modelUrl.toString();
        int position = urlString.indexOf(ROOT_RESOURCE_PATH);
        if (position == -1) {
            throw new IllegalArgumentException("Invalid Smithy model URL: " + modelUrl);
        }
        return urlString.substring(position + ROOT_RESOURCE_PATH.length());
    }

    public static URL createSmithyJarManifestUrl(String fileOrUrl) {
        try {
            return new URL(ModelDiscovery.getFilenameWithScheme(fileOrUrl) + "!/" + MANIFEST_PATH);
        }
        catch (IOException e) {
            throw new ModelImportException(e.getMessage(), e);
        }
    }

    private static String getFilenameWithScheme(String filename) {
        if (filename.startsWith("jar:")) {
            return filename;
        }
        if (filename.startsWith("file:")) {
            return "jar:" + filename;
        }
        return "jar:file:" + filename;
    }

    private static Set<String> parseManifest(URL location) throws IOException {
        LinkedHashSet<String> models = new LinkedHashSet<String>();
        URLConnection connection = location.openConnection();
        connection.setUseCaches(false);
        try (InputStream input = connection.getInputStream();
             BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#') continue;
                if (!ModelDiscovery.isValidateResourceLine(line)) {
                    throw new ModelManifestException(String.format("Illegal Smithy model manifest syntax found in `%s`: `%s`", location, line));
                }
                models.add(line);
            }
        }
        return models;
    }

    private static boolean isValidateResourceLine(String line) {
        for (String segment : line.split("/")) {
            if (segment.isEmpty() || segment.equals(".") || segment.equals("..")) {
                return false;
            }
            if (!PROHIBITED_RESOURCE_SEGMENT_CHARS.matcher(segment).find()) continue;
            return false;
        }
        return line.charAt(line.length() - 1) != '/';
    }
}

