/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public enum IdlToken {
    SPACE(" "){

        @Override
        public boolean canSkipBeforeBr() {
            return true;
        }

        @Override
        public boolean isWhitespace() {
            return true;
        }
    }
    ,
    NEWLINE("\\n"){

        @Override
        public boolean isWhitespace() {
            return true;
        }
    }
    ,
    COMMA(","){

        @Override
        public boolean canSkipBeforeBr() {
            return true;
        }

        @Override
        public boolean isWhitespace() {
            return true;
        }
    }
    ,
    COMMENT("//"){

        @Override
        public boolean isWhitespace() {
            return true;
        }
    }
    ,
    DOC_COMMENT("///"),
    AT("@"),
    STRING("\""),
    TEXT_BLOCK("\"\"\""),
    COLON(":"),
    WALRUS(":="),
    IDENTIFIER(""),
    DOT("."),
    POUND("#"),
    DOLLAR("$"),
    NUMBER(""),
    LBRACE("{"),
    RBRACE("}"),
    LBRACKET("["),
    RBRACKET("]"),
    LPAREN("("),
    RPAREN(")"),
    EQUAL("="),
    EOF(""),
    ERROR("");

    private final String exampleLexeme;

    private IdlToken(String exampleLexeme) {
        this.exampleLexeme = exampleLexeme;
    }

    public String getDebug() {
        return this.getDebug(this.exampleLexeme);
    }

    public String getDebug(CharSequence lexeme) {
        if (lexeme.length() > 0) {
            return (Object)((Object)this) + "('" + lexeme + "')";
        }
        return this.toString();
    }

    public boolean isWhitespace() {
        return false;
    }

    boolean canSkipBeforeBr() {
        return false;
    }
}

