/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.function.Consumer;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.IdlReferenceResolver;
import software.amazon.smithy.model.loader.IdlShapeIdParser;
import software.amazon.smithy.model.loader.IdlToken;
import software.amazon.smithy.model.loader.IdlTokenizer;
import software.amazon.smithy.model.loader.ModelSyntaxException;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.BooleanNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NullNode;
import software.amazon.smithy.model.node.NumberNode;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.Pair;

final class IdlNodeParser {
    private static final String SYNTACTIC_SHAPE_ID_TARGET = "SyntacticShapeIdTarget";

    private IdlNodeParser() {
    }

    static Node expectAndSkipNode(IdlTokenizer tokenizer, IdlReferenceResolver resolver) {
        return IdlNodeParser.expectAndSkipNode(tokenizer, resolver, tokenizer.getCurrentTokenLocation());
    }

    static Node expectAndSkipNode(IdlTokenizer tokenizer, IdlReferenceResolver resolver, SourceLocation location) {
        IdlToken token = tokenizer.expect(IdlToken.STRING, IdlToken.TEXT_BLOCK, IdlToken.NUMBER, IdlToken.IDENTIFIER, IdlToken.LBRACE, IdlToken.LBRACKET);
        switch (token) {
            case STRING: 
            case TEXT_BLOCK: {
                StringNode result = new StringNode(tokenizer.getCurrentTokenStringSlice().toString(), location);
                tokenizer.next();
                return result;
            }
            case IDENTIFIER: {
                String shapeId = tokenizer.internString(IdlShapeIdParser.expectAndSkipShapeId(tokenizer));
                return IdlNodeParser.parseIdentifier(resolver, shapeId, location);
            }
            case NUMBER: {
                Number number = tokenizer.getCurrentTokenNumberValue();
                tokenizer.next();
                return new NumberNode(number, location);
            }
            case LBRACE: {
                return IdlNodeParser.parseObjectNode(tokenizer, resolver, location);
            }
        }
        return IdlNodeParser.parseArrayNode(tokenizer, resolver, location);
    }

    static Node parseIdentifier(IdlReferenceResolver resolver, String identifier, SourceLocation location) {
        Keyword keyword = Keyword.from(identifier);
        return keyword == null ? IdlNodeParser.parseSyntacticShapeId(resolver, identifier, location) : keyword.createNode(location);
    }

    private static Node parseSyntacticShapeId(IdlReferenceResolver resolver, String identifier, SourceLocation location) {
        Pair<StringNode, Consumer<String>> pair = StringNode.createLazyString(identifier, location);
        Consumer consumer = (Consumer)pair.right;
        resolver.resolve(identifier, (id, type) -> {
            consumer.accept(id.toString());
            if (type != null) {
                return null;
            }
            return ValidationEvent.builder().id(SYNTACTIC_SHAPE_ID_TARGET).severity(Severity.DANGER).message(String.format("Syntactic shape ID `%s` does not resolve to a valid shape ID: `%s`. Did you mean to quote this string? Are you missing a model file?", identifier, id)).sourceLocation(location).build();
        });
        return (Node)pair.left;
    }

    private static ArrayNode parseArrayNode(IdlTokenizer tokenizer, IdlReferenceResolver resolver, SourceLocation location) {
        tokenizer.increaseNestingLevel();
        ArrayNode.Builder builder = ArrayNode.builder().sourceLocation(location);
        tokenizer.expect(IdlToken.LBRACKET);
        tokenizer.next();
        tokenizer.skipWsAndDocs();
        while (tokenizer.getCurrentToken() != IdlToken.RBRACKET) {
            builder.withValue(IdlNodeParser.expectAndSkipNode(tokenizer, resolver));
            tokenizer.skipWsAndDocs();
        }
        tokenizer.expect(IdlToken.RBRACKET);
        tokenizer.next();
        tokenizer.decreaseNestingLevel();
        return builder.build();
    }

    private static ObjectNode parseObjectNode(IdlTokenizer tokenizer, IdlReferenceResolver resolver, SourceLocation location) {
        tokenizer.expect(IdlToken.LBRACE);
        tokenizer.next();
        tokenizer.skipWsAndDocs();
        tokenizer.increaseNestingLevel();
        ObjectNode.Builder builder = ObjectNode.builder().sourceLocation(location);
        while (tokenizer.hasNext() && tokenizer.expect(IdlToken.RBRACE, IdlToken.STRING, IdlToken.IDENTIFIER) != IdlToken.RBRACE) {
            String key = tokenizer.internString(tokenizer.getCurrentTokenStringSlice());
            SourceLocation keyLocation = tokenizer.getCurrentTokenLocation();
            tokenizer.next();
            tokenizer.skipWsAndDocs();
            tokenizer.expect(IdlToken.COLON);
            tokenizer.next();
            tokenizer.skipWsAndDocs();
            Node value = IdlNodeParser.expectAndSkipNode(tokenizer, resolver);
            if (builder.hasMember(key)) {
                throw new ModelSyntaxException("Duplicate member: '" + key + '\'', keyLocation);
            }
            builder.withMember(key, value);
            tokenizer.skipWsAndDocs();
        }
        tokenizer.expect(IdlToken.RBRACE);
        tokenizer.next();
        tokenizer.decreaseNestingLevel();
        return builder.build();
    }

    private static enum Keyword {
        TRUE{

            @Override
            protected Node createNode(SourceLocation location) {
                return new BooleanNode(true, location);
            }
        }
        ,
        FALSE{

            @Override
            protected Node createNode(SourceLocation location) {
                return new BooleanNode(false, location);
            }
        }
        ,
        NULL{

            @Override
            protected Node createNode(SourceLocation location) {
                return new NullNode(location);
            }
        };


        protected abstract Node createNode(SourceLocation var1);

        static Keyword from(String keyword) {
            switch (keyword) {
                case "true": {
                    return TRUE;
                }
                case "false": {
                    return FALSE;
                }
                case "null": {
                    return NULL;
                }
            }
            return null;
        }
    }
}

