/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.Pair;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class MapShape
extends Shape
implements ToSmithyBuilder<MapShape> {
    private final MemberShape key;
    private final MemberShape value;
    private transient Map<String, MemberShape> memberMap;

    private MapShape(Builder builder) {
        super(builder, false);
        this.key = this.getRequiredMixinMember(builder, builder.key, "key");
        this.value = this.getRequiredMixinMember(builder, builder.value, "value");
        this.validateMemberShapeIds();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return this.updateBuilder(MapShape.builder()).key(this.key).value(this.value);
    }

    @Override
    public <R> R accept(ShapeVisitor<R> visitor) {
        return visitor.mapShape(this);
    }

    @Override
    public Optional<MapShape> asMapShape() {
        return Optional.of(this);
    }

    @Override
    public ShapeType getType() {
        return ShapeType.MAP;
    }

    public MemberShape getValue() {
        return this.value;
    }

    public MemberShape getKey() {
        return this.key;
    }

    @Override
    public Optional<MemberShape> getMember(String memberName) {
        if ("key".equals(memberName)) {
            return Optional.of(this.key);
        }
        if ("value".equals(memberName)) {
            return Optional.of(this.value);
        }
        return Optional.empty();
    }

    @Override
    public Map<String, MemberShape> getAllMembers() {
        AbstractMap<String, MemberShape> result = this.memberMap;
        if (result == null) {
            this.memberMap = result = new AbstractMap<String, MemberShape>(){
                private transient Set<Map.Entry<String, MemberShape>> entries;
                private transient List<MemberShape> values;

                @Override
                public MemberShape get(Object keyName) {
                    if ("key".equals(keyName)) {
                        return MapShape.this.key;
                    }
                    if ("value".equals(keyName)) {
                        return MapShape.this.value;
                    }
                    return null;
                }

                @Override
                public boolean containsKey(Object keyName) {
                    return "key".equals(keyName) || "value".equals(keyName);
                }

                @Override
                public Set<String> keySet() {
                    return SetUtils.of((Object[])new String[]{"key", "value"});
                }

                @Override
                public Collection<MemberShape> values() {
                    List result = this.values;
                    if (result == null) {
                        this.values = result = ListUtils.of((Object)MapShape.this.key, (Object)MapShape.this.value);
                    }
                    return result;
                }

                @Override
                public Set<Map.Entry<String, MemberShape>> entrySet() {
                    Set result = this.entries;
                    if (result == null) {
                        this.entries = result = SetUtils.of((Object[])new Map.Entry[]{Pair.of((Object)"key", (Object)MapShape.this.key), Pair.of((Object)"value", (Object)MapShape.this.value)});
                    }
                    return result;
                }
            };
        }
        return result;
    }

    public static final class Builder
    extends AbstractShapeBuilder<Builder, MapShape> {
        private MemberShape key;
        private MemberShape value;

        public MapShape build() {
            return new MapShape(this);
        }

        @Override
        public ShapeType getShapeType() {
            return ShapeType.MAP;
        }

        @Override
        public Builder id(ShapeId shapeId) {
            if (this.key != null) {
                this.key(((MemberShape.Builder)this.key.toBuilder().id(shapeId.withMember(this.key.getMemberName()))).build());
            }
            if (this.value != null) {
                this.value(((MemberShape.Builder)this.value.toBuilder().id(shapeId.withMember(this.value.getMemberName()))).build());
            }
            return (Builder)super.id(shapeId);
        }

        public Builder key(MemberShape member) {
            this.key = Objects.requireNonNull(member);
            return this;
        }

        public Builder value(MemberShape member) {
            this.value = Objects.requireNonNull(member);
            return this;
        }

        @Override
        public Builder addMember(MemberShape member) {
            if (member.getMemberName().equals("key")) {
                return this.key(member);
            }
            if (member.getMemberName().equals("value")) {
                return this.value(member);
            }
            throw new IllegalStateException("Invalid member given to MapShape builder: " + member.getId());
        }

        @Override
        public Builder clearMembers() {
            this.key = null;
            this.value = null;
            return this;
        }

        public Builder key(ShapeId target) {
            return this.key(target, null);
        }

        public Builder key(ShapeId target, Consumer<MemberShape.Builder> memberUpdater) {
            if (this.getId() == null) {
                throw new IllegalStateException("An id must be set before setting a member with a target");
            }
            MemberShape.Builder builder = (MemberShape.Builder)MemberShape.builder().target(target).id(this.getId().withMember("key"));
            if (memberUpdater != null) {
                memberUpdater.accept(builder);
            }
            return this.key(builder.build());
        }

        public Builder value(ShapeId target) {
            return this.value(target, null);
        }

        public Builder value(ShapeId target, Consumer<MemberShape.Builder> memberUpdater) {
            if (this.getId() == null) {
                throw new IllegalStateException("An id must be set before setting a member with a target");
            }
            MemberShape.Builder builder = (MemberShape.Builder)MemberShape.builder().target(target).id(this.getId().withMember("value"));
            if (memberUpdater != null) {
                memberUpdater.accept(builder);
            }
            return this.value(builder.build());
        }

        @Override
        public Builder flattenMixins() {
            if (this.getMixins().isEmpty()) {
                return this;
            }
            for (Shape mixin : this.getMixins().values()) {
                for (MemberShape member : mixin.members()) {
                    SourceLocation location = this.getSourceLocation();
                    Collection<Object> localTraits = Collections.emptyList();
                    MemberShape existing = member.getMemberName().equals("key") ? this.key : this.value;
                    if (existing != null) {
                        localTraits = existing.getIntroducedTraits().values();
                        location = existing.getSourceLocation();
                    }
                    this.addMember(((MemberShape.Builder)((MemberShape.Builder)((MemberShape.Builder)((MemberShape.Builder)MemberShape.builder().id(this.getId().withMember(member.getMemberName()))).target(member.getTarget()).addTraits(member.getAllTraits().values())).addTraits(localTraits)).source(location)).build());
                }
            }
            return (Builder)super.flattenMixins();
        }
    }
}

