/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.knowledge;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.StreamingTrait;

public final class EventStreamInfo {
    private final OperationShape operation;
    private final StructureShape structure;
    private final MemberShape eventStreamMember;
    private final Shape eventStreamTarget;
    private final Map<String, MemberShape> initialMembers;
    private final Map<String, Shape> initialTargets;
    private final Map<String, StructureShape> events;
    private final StreamingTrait streamingTrait;

    EventStreamInfo(OperationShape operation, StreamingTrait streamingTrait, StructureShape structure, MemberShape eventStreamMember, Shape eventStreamTarget, Map<String, MemberShape> initialMembers, Map<String, Shape> initialTargets, Map<String, StructureShape> events) {
        this.operation = operation;
        this.streamingTrait = streamingTrait;
        this.structure = structure;
        this.eventStreamMember = eventStreamMember;
        this.eventStreamTarget = eventStreamTarget;
        this.initialMembers = Collections.unmodifiableMap(initialMembers);
        this.initialTargets = Collections.unmodifiableMap(initialTargets);
        this.events = events;
    }

    public OperationShape getOperation() {
        return this.operation;
    }

    public StreamingTrait getStreamingTrait() {
        return this.streamingTrait;
    }

    public StructureShape getStructure() {
        return this.structure;
    }

    public MemberShape getEventStreamMember() {
        return this.eventStreamMember;
    }

    public Shape getEventStreamTarget() {
        return this.eventStreamTarget;
    }

    public Map<String, MemberShape> getInitialMessageMembers() {
        return this.initialMembers;
    }

    public Map<String, Shape> getInitialMessageTargets() {
        return this.initialTargets;
    }

    public boolean hasInitialMessage() {
        return !this.initialMembers.isEmpty();
    }

    public Map<String, StructureShape> getEvents() {
        return this.events;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EventStreamInfo)) {
            return false;
        }
        EventStreamInfo that = (EventStreamInfo)o;
        return this.operation.getId().equals(that.operation.getId()) && this.structure.getId().equals(that.structure.getId()) && this.eventStreamMember.getId().equals(that.eventStreamMember.getId()) && this.initialMembers.equals(that.initialMembers);
    }

    public int hashCode() {
        return Objects.hash(this.operation.getId(), this.structure.getId());
    }
}

