/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class MixinValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (StructureShape structureShape : model.toSet(StructureShape.class)) {
            this.validateShape(model, structureShape, events);
        }
        for (UnionShape unionShape : model.toSet(UnionShape.class)) {
            this.validateShape(model, unionShape, events);
        }
        return events;
    }

    private void validateShape(Model model, Shape shape, List<ValidationEvent> events) {
        if (!shape.getMixins().isEmpty()) {
            this.validateMemberSources(model, shape, events);
        }
    }

    private void validateMemberSources(Model model, Shape shape, List<ValidationEvent> events) {
        HashMap memberSources = new HashMap();
        for (MemberShape memberShape : shape.members()) {
            if (!memberShape.getMixins().isEmpty()) continue;
            TreeSet<ShapeId> self = new TreeSet<ShapeId>();
            self.add(shape.getId());
            memberSources.put(memberShape.getMemberName(), self);
        }
        for (ShapeId shapeId : shape.getMixins()) {
            model.getShape(shapeId).ifPresent(mixinShape -> {
                for (MemberShape member : mixinShape.members()) {
                    memberSources.computeIfAbsent(member.getMemberName(), name -> new TreeSet()).add(mixin);
                }
            });
        }
        memberSources.entrySet().removeIf(e -> ((Set)e.getValue()).size() <= 1);
        if (!memberSources.isEmpty()) {
            for (Map.Entry entry : memberSources.entrySet()) {
                String memberName = (String)entry.getKey();
                Set conflicts = (Set)entry.getValue();
                String message = String.format("Member `%s` conflicts with members defined in the following mixins: %s", memberName, conflicts);
                events.add(this.error(shape, message));
            }
        }
    }
}

