/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.MixinTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.SmithyBuilder;

public abstract class AbstractShapeBuilder<B extends AbstractShapeBuilder<B, S>, S extends Shape>
implements SmithyBuilder<S>,
FromSourceLocation {
    private ShapeId id;
    private final BuilderRef<Map<ShapeId, Trait>> traits = BuilderRef.forUnorderedMap();
    private SourceLocation source = SourceLocation.none();
    private Map<ShapeId, Shape> mixins;

    AbstractShapeBuilder() {
    }

    @Override
    public SourceLocation getSourceLocation() {
        return this.source;
    }

    public abstract ShapeType getShapeType();

    public ShapeId getId() {
        return this.id;
    }

    public B id(ShapeId shapeId) {
        this.id = shapeId;
        return (B)this;
    }

    public B id(String shapeId) {
        return this.id(ShapeId.from(shapeId));
    }

    public B source(SourceLocation sourceLocation) {
        if (sourceLocation == null) {
            throw new IllegalArgumentException("source must not be null");
        }
        this.source = sourceLocation;
        return (B)this;
    }

    public B source(String filename, int line, int column) {
        return this.source(new SourceLocation(filename, line, column));
    }

    public B traits(Collection<Trait> traitsToSet) {
        this.clearTraits();
        for (Trait trait : traitsToSet) {
            this.addTrait(trait);
        }
        return (B)this;
    }

    public Map<ShapeId, Trait> getAllTraits() {
        return (Map)this.traits.peek();
    }

    public B addTraits(Collection<? extends Trait> traitsToAdd) {
        for (Trait trait : traitsToAdd) {
            this.addTrait(trait);
        }
        return (B)this;
    }

    public B addTrait(Trait trait) {
        Objects.requireNonNull(trait, "trait must not be null");
        ((Map)this.traits.get()).put(trait.toShapeId(), trait);
        return (B)this;
    }

    public B removeTrait(String traitId) {
        return this.removeTrait(ShapeId.from(Trait.makeAbsoluteName(traitId)));
    }

    public B removeTrait(ShapeId traitId) {
        if (this.traits.hasValue()) {
            ((Map)this.traits.get()).remove(traitId);
        }
        return (B)this;
    }

    public B clearTraits() {
        this.traits.clear();
        return (B)this;
    }

    public B addMember(MemberShape member) {
        throw new UnsupportedOperationException(String.format("Member `%s` cannot be added to %s", member.getId(), this.getClass().getName()));
    }

    public B clearMembers() {
        return (B)this;
    }

    public B addMixin(Shape shape) {
        if (this.mixins == null) {
            this.mixins = new LinkedHashMap<ShapeId, Shape>();
        }
        this.mixins.put(shape.getId(), shape);
        return (B)this;
    }

    public B mixins(Collection<? extends Shape> mixins) {
        for (Shape shape : mixins) {
            this.addMixin(shape);
        }
        return (B)this;
    }

    public B removeMixin(ToShapeId shape) {
        if (this.mixins != null) {
            this.mixins.remove(shape.toShapeId());
        }
        return (B)this;
    }

    public B clearMixins() {
        if (this.mixins != null) {
            ArrayList<ShapeId> mixinIds = new ArrayList<ShapeId>(this.mixins.keySet());
            for (ShapeId id : mixinIds) {
                this.removeMixin(id);
            }
        }
        return (B)this;
    }

    public B flattenMixins() {
        if (this.mixins == null || this.mixins.isEmpty()) {
            return (B)this;
        }
        for (Shape mixin : this.mixins.values()) {
            Map<ShapeId, Trait> nonLocalTraits = MixinTrait.getNonLocalTraitsFromMap(mixin.getAllTraits());
            for (Map.Entry<ShapeId, Trait> entry : nonLocalTraits.entrySet()) {
                if (this.traits.hasValue() && ((Map)this.traits.get()).containsKey(entry.getKey())) continue;
                this.addTrait(entry.getValue());
            }
        }
        this.mixins.clear();
        return (B)this;
    }

    Map<ShapeId, Shape> getMixins() {
        return this.mixins == null ? Collections.emptyMap() : this.mixins;
    }

    Map<ShapeId, Trait> getTraits() {
        return (Map)this.traits.get();
    }
}

