/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NeighborProviderIndex;
import software.amazon.smithy.model.selector.AndSelector;
import software.amazon.smithy.model.selector.Context;
import software.amazon.smithy.model.selector.InternalSelector;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.Shape;

final class WrappedSelector
implements Selector {
    private static final int PARALLEL_THRESHOLD = 10000;
    private final String expression;
    private final InternalSelector delegate;
    private final Function<Model, Collection<? extends Shape>> optimizer;

    WrappedSelector(String expression, List<InternalSelector> selectors) {
        this.expression = expression;
        this.delegate = AndSelector.of(selectors);
        this.optimizer = selectors.get(0).optimize();
    }

    public String toString() {
        return this.expression;
    }

    public boolean equals(Object other) {
        return other instanceof Selector && this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    @Override
    public Set<Shape> select(Model model) {
        if (this.isParallel(model)) {
            return this.shapes(model).collect(Collectors.toSet());
        }
        HashSet<Shape> result = new HashSet<Shape>();
        this.pushShapes(model, (ctx, s) -> {
            result.add(s);
            return true;
        });
        return result;
    }

    @Override
    public void consumeMatches(Model model, Consumer<Selector.ShapeMatch> shapeMatchConsumer) {
        this.pushShapes(model, (ctx, s) -> {
            shapeMatchConsumer.accept(new Selector.ShapeMatch(s, ctx.getVars()));
            return true;
        });
    }

    @Override
    public Stream<Shape> shapes(Model model) {
        return this.streamStartingShape(model).flatMap(shape -> {
            ArrayList result = new ArrayList();
            this.delegate.push(this.createContext(model), (Shape)shape, (ctx, s) -> {
                result.add(s);
                return true;
            });
            return result.stream();
        });
    }

    @Override
    public Stream<Selector.ShapeMatch> matches(Model model) {
        return this.streamStartingShape(model).flatMap(shape -> {
            ArrayList result = new ArrayList();
            this.delegate.push(this.createContext(model), (Shape)shape, (ctx, s) -> {
                result.add(new Selector.ShapeMatch(s, ctx.getVars()));
                return true;
            });
            return result.stream();
        });
    }

    private Context createContext(Model model) {
        return new Context(NeighborProviderIndex.of(model));
    }

    private void pushShapes(Model model, InternalSelector.Receiver acceptor) {
        Context context = this.createContext(model);
        Set<Shape> shapes = this.optimizer == null ? model.toSet() : this.optimizer.apply(model);
        for (Shape shape : shapes) {
            this.delegate.push(context.clearVars(), shape, acceptor);
        }
    }

    private Stream<? extends Shape> streamStartingShape(Model model) {
        Stream<Shape> stream;
        Stream<Shape> stream2 = stream = this.optimizer != null ? this.optimizer.apply(model).stream() : model.shapes();
        if (this.isParallel(model)) {
            stream = (Stream<Shape>)stream.parallel();
        }
        return stream;
    }

    private boolean isParallel(Model model) {
        return model.getShapeIds().size() >= 10000;
    }
}

