/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform;

import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.PrivateTrait;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.model.transform.MarkAndSweep;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.utils.FunctionalUtils;

final class ScrubTraitDefinitions {
    ScrubTraitDefinitions() {
    }

    Model transform(ModelTransformer transformer, Model model) {
        return this.transform(transformer, model, FunctionalUtils.alwaysTrue());
    }

    Model transform(ModelTransformer transformer, Model model, Predicate<Shape> keepFilter) {
        Set toMark = Stream.concat(model.shapes().filter(shape -> ScrubTraitDefinitions.isTraitDefinitionToRemove(shape, keepFilter)), model.shapes().filter(shape -> Prelude.isPreludeShape(shape) && shape.hasTrait(PrivateTrait.class))).collect(Collectors.toSet());
        MarkAndSweep markAndSweep = new MarkAndSweep(context -> {
            toMark.forEach(context::markShape);
            toMark.clear();
        }, ScrubTraitDefinitions::notPublicPreludeShape);
        return transformer.removeShapes(model, markAndSweep.markAndSweep(model));
    }

    private static boolean notPublicPreludeShape(Shape shape) {
        return !Prelude.isPublicPreludeShape(shape.getId()) || shape.hasTrait(TraitDefinition.class);
    }

    private static boolean isTraitDefinitionToRemove(Shape shape, Predicate<Shape> keepFilter) {
        return shape.hasTrait(TraitDefinition.class) && keepFilter.test(shape);
    }
}

