/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.BooleanNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NumberNode;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.CollectionShape;
import software.amazon.smithy.model.shapes.EnumShape;
import software.amazon.smithy.model.shapes.IntEnumShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.AnnotationTrait;
import software.amazon.smithy.model.traits.DefaultTrait;
import software.amazon.smithy.model.traits.DocumentationTrait;
import software.amazon.smithy.model.traits.EnumValueTrait;
import software.amazon.smithy.model.traits.IdRefTrait;
import software.amazon.smithy.model.traits.InputTrait;
import software.amazon.smithy.model.traits.OutputTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.model.traits.UnitTypeTrait;
import software.amazon.smithy.utils.AbstractCodeWriter;
import software.amazon.smithy.utils.CodeWriter;
import software.amazon.smithy.utils.FunctionalUtils;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.StringUtils;

public final class SmithyIdlModelSerializer {
    private final Predicate<String> metadataFilter;
    private final Predicate<Shape> shapeFilter;
    private final Predicate<Trait> traitFilter;
    private final Function<Shape, Path> shapePlacer;
    private final Path basePath;

    private SmithyIdlModelSerializer(Builder builder) {
        this.metadataFilter = builder.metadataFilter;
        this.shapeFilter = builder.serializePrelude ? builder.shapeFilter : builder.shapeFilter.and(FunctionalUtils.not(Prelude::isPreludeShape));
        this.traitFilter = builder.traitFilter.and(FunctionalUtils.not(Trait::isSynthetic));
        this.basePath = builder.basePath;
        if (this.basePath != null) {
            Function shapePlacer = builder.shapePlacer;
            this.shapePlacer = shape -> this.basePath.resolve((Path)shapePlacer.apply(shape));
        } else {
            this.shapePlacer = builder.shapePlacer;
        }
    }

    public Map<Path, String> serialize(Model model) {
        Map<Path, String> result = model.shapes().filter(FunctionalUtils.not(Shape::isMemberShape)).filter(this.shapeFilter).collect(Collectors.groupingBy(this.shapePlacer)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.serialize(model, (Collection)entry.getValue())));
        if (result.isEmpty()) {
            Path path = Paths.get("metadata.smithy", new String[0]);
            if (this.basePath != null) {
                path = this.basePath.resolve(path);
            }
            return Collections.singletonMap(path, this.serializeHeader(model, null));
        }
        return result;
    }

    private String serialize(Model fullModel, Collection<Shape> shapes) {
        Set namespaces = shapes.stream().map(shape -> shape.getId().getNamespace()).collect(Collectors.toSet());
        if (namespaces.size() != 1) {
            throw new RuntimeException("All shapes in a single file must share a namespace.");
        }
        String namespace = (String)namespaces.iterator().next();
        SmithyCodeWriter codeWriter = new SmithyCodeWriter(namespace, fullModel);
        NodeSerializer nodeSerializer = new NodeSerializer(codeWriter, fullModel);
        Set<ShapeId> inlineableShapes = this.getInlineableShapes(fullModel, shapes);
        ShapeSerializer shapeSerializer = new ShapeSerializer(codeWriter, nodeSerializer, this.traitFilter, fullModel, inlineableShapes);
        shapes.stream().filter(FunctionalUtils.not(Shape::isMemberShape)).filter(shape -> !inlineableShapes.contains(shape.getId())).sorted(new ShapeComparator()).forEach(shape -> shape.accept(shapeSerializer));
        return this.serializeHeader(fullModel, namespace) + codeWriter.toString();
    }

    private Set<ShapeId> getInlineableShapes(Model fullModel, Collection<Shape> shapes) {
        HashSet<ShapeId> inlineableShapes = new HashSet<ShapeId>();
        for (Shape shape : shapes) {
            Shape outputShape;
            Shape inputShape;
            if (!shape.isOperationShape()) continue;
            OperationShape operation = shape.asOperationShape().get();
            if (!operation.getInputShape().equals(UnitTypeTrait.UNIT) && shapes.contains(inputShape = fullModel.expectShape(operation.getInputShape())) && inputShape.hasTrait(InputTrait.ID) && operation.getInputShape().getName().equals(operation.getId().getName() + "Input")) {
                inlineableShapes.add(operation.getInputShape());
            }
            if (operation.getOutputShape().equals(UnitTypeTrait.UNIT) || !shapes.contains(outputShape = fullModel.expectShape(operation.getOutputShape())) || !outputShape.hasTrait(OutputTrait.ID) || !operation.getOutputShape().getName().equals(operation.getId().getName() + "Output")) continue;
            inlineableShapes.add(operation.getOutputShape());
        }
        return inlineableShapes;
    }

    private String serializeHeader(Model fullModel, String namespace) {
        SmithyCodeWriter codeWriter = new SmithyCodeWriter(null, fullModel);
        NodeSerializer nodeSerializer = new NodeSerializer(codeWriter, fullModel);
        codeWriter.write("$$version: \"$L\"", new Object[]{"2.0"}).write((Object)"", new Object[0]);
        fullModel.getMetadata().entrySet().stream().filter(entry -> this.metadataFilter.test((String)entry.getKey())).sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            codeWriter.trimTrailingSpaces(false).writeInline((Object)"metadata $K = ", new Object[]{entry.getKey()}).trimTrailingSpaces();
            nodeSerializer.serialize((Node)entry.getValue());
            codeWriter.write("", new Object[0]);
        });
        if (!fullModel.getMetadata().isEmpty()) {
            codeWriter.write("", new Object[0]);
        }
        if (namespace != null) {
            codeWriter.write("namespace $L", new Object[]{namespace}).write((Object)"", new Object[0]).trimBlankLines(-1);
        }
        return codeWriter.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Path placeShapesByNamespace(Shape shape) {
        return Paths.get(shape.getId().getNamespace() + ".smithy", new String[0]);
    }

    private static final class SmithyCodeWriter
    extends CodeWriter {
        private static final Pattern UNQUOTED_KEY_STRING = Pattern.compile("[a-zA-Z_][a-zA-Z_0-9]*");
        private final String namespace;
        private final Model model;
        private final Set<ShapeId> imports;

        SmithyCodeWriter(String namespace, Model model) {
            this.namespace = namespace;
            this.model = model;
            this.imports = new HashSet<ShapeId>();
            this.trimTrailingSpaces();
            this.trimBlankLines();
            this.putFormatter('I', (s, i) -> this.formatShapeId(s));
            this.putFormatter('K', this::optionallyQuoteKey);
        }

        private SmithyCodeWriter openBlockInline(String content, Object ... args) {
            this.writeInline(content, args).indent();
            return this;
        }

        private SmithyCodeWriter closeBlockWithoutNewline(String content, Object ... args) {
            this.setNewline("");
            this.closeBlock(content, args);
            this.setNewline("\n");
            return this;
        }

        private SmithyCodeWriter writeIndent() {
            this.setNewline("");
            this.trimTrailingSpaces(false);
            this.write("", new Object[0]);
            this.trimTrailingSpaces();
            this.setNewline("\n");
            return this;
        }

        private String formatShapeId(Object value) {
            if (value == null) {
                return "";
            }
            ShapeId shapeId = ShapeId.from(String.valueOf(value));
            if (!this.shouldWriteNamespace(shapeId)) {
                return shapeId.asRelativeReference();
            }
            return shapeId.toString();
        }

        private boolean shouldWriteNamespace(ShapeId shapeId) {
            if (shapeId.getNamespace().equals(this.namespace)) {
                return false;
            }
            if (Prelude.isPublicPreludeShape(shapeId)) {
                return this.conflictsWithLocalNamespace(shapeId);
            }
            if (this.shouldImport(shapeId)) {
                this.imports.add(shapeId.withoutMember());
            }
            return !this.imports.contains(shapeId);
        }

        private boolean conflictsWithLocalNamespace(ShapeId shapeId) {
            return this.model.getShape(ShapeId.fromParts(this.namespace, shapeId.getName())).isPresent();
        }

        private boolean shouldImport(ShapeId shapeId) {
            return !this.conflictsWithLocalNamespace(shapeId) && !this.conflictsWithPreludeNamespace(shapeId) && !this.conflictsWithImports(shapeId);
        }

        private boolean conflictsWithPreludeNamespace(ShapeId shapeId) {
            return Prelude.isPublicPreludeShape(ShapeId.fromParts("smithy.api", shapeId.getName()));
        }

        private boolean conflictsWithImports(ShapeId shapeId) {
            return this.imports.stream().anyMatch(importId -> importId.getName().equals(shapeId.getName()));
        }

        private SmithyCodeWriter writeOptionalIdList(String textBeforeList, Collection<ShapeId> shapeIds) {
            if (shapeIds.isEmpty()) {
                return this;
            }
            this.openBlock("$L: [", new Object[]{textBeforeList});
            shapeIds.stream().sorted().forEach(shapeId -> this.write("$I", new Object[]{shapeId}));
            this.closeBlock("]", new Object[0]);
            return this;
        }

        private String optionallyQuoteKey(Object key, String indent) {
            String formatted = AbstractCodeWriter.formatLiteral((Object)key);
            if (UNQUOTED_KEY_STRING.matcher(formatted).matches()) {
                return formatted;
            }
            return StringUtils.escapeJavaString((Object)formatted, (String)indent);
        }

        public String toString() {
            String contents = StringUtils.stripStart((String)super.toString(), null);
            if (this.imports.isEmpty()) {
                return contents;
            }
            String importString = this.imports.stream().sorted().map(shapeId -> String.format("use %s", shapeId.toString())).collect(Collectors.joining("\n"));
            return importString + "\n\n" + contents;
        }
    }

    private static final class NodeSerializer {
        private final SmithyCodeWriter codeWriter;
        private final Model model;

        NodeSerializer(SmithyCodeWriter codeWriter, Model model) {
            this.codeWriter = codeWriter;
            this.model = model;
        }

        private void serialize(Node node) {
            this.serialize(node, null);
        }

        private void serialize(Node node, Shape shape) {
            if (this.isShapeId(shape)) {
                this.serializeShapeId(node.expectStringNode());
                return;
            }
            if (shape != null && shape.isMemberShape()) {
                shape = this.model.expectShape(shape.asMemberShape().get().getTarget());
            }
            if (node.isStringNode()) {
                this.serializeString(node.expectStringNode());
            } else if (node.isNumberNode()) {
                this.serializeNumber(node.expectNumberNode());
            } else if (node.isBooleanNode()) {
                this.serializeBoolean(node.expectBooleanNode());
            } else if (node.isNullNode()) {
                this.serializeNull();
            } else if (node.isArrayNode()) {
                this.serializeArray(node.expectArrayNode(), shape);
            } else if (node.isObjectNode()) {
                this.serializeObject(node.expectObjectNode(), shape);
            }
        }

        private boolean isShapeId(Shape shape) {
            if (shape == null) {
                return false;
            }
            return shape.getMemberTrait(this.model, IdRefTrait.class).isPresent();
        }

        private void serializeString(StringNode node) {
            this.codeWriter.writeInline("$S", new Object[]{node.getValue()});
        }

        private void serializeShapeId(StringNode node) {
            this.codeWriter.writeInline("$I", new Object[]{node.getValue()});
        }

        private void serializeNumber(NumberNode node) {
            this.codeWriter.writeInline("$L", new Object[]{node.getValue()});
        }

        private void serializeBoolean(BooleanNode node) {
            this.codeWriter.writeInline(String.valueOf(node.getValue()), new Object[0]);
        }

        private void serializeNull() {
            this.codeWriter.writeInline("null", new Object[0]);
        }

        private void serializeArray(ArrayNode node, Shape shape) {
            if (node.isEmpty()) {
                this.codeWriter.writeInline("[]", new Object[0]);
                return;
            }
            this.codeWriter.openBlockInline("[", new Object[0]);
            Shape member = shape;
            if (shape instanceof CollectionShape) {
                member = ((CollectionShape)shape).getMember();
            }
            for (Node element : node.getElements()) {
                this.codeWriter.write("", new Object[0]);
                this.codeWriter.writeIndent();
                this.serialize(element, member);
            }
            this.codeWriter.write("", new Object[0]);
            this.codeWriter.closeBlockWithoutNewline("]", new Object[0]);
        }

        private void serializeObject(ObjectNode node, Shape shape) {
            if (node.isEmpty()) {
                this.codeWriter.writeInline("{}", new Object[0]);
                return;
            }
            this.codeWriter.openBlockInline("{", new Object[0]);
            this.serializeKeyValuePairs(node, shape);
            this.codeWriter.closeBlockWithoutNewline("}", new Object[0]);
        }

        private void serializeKeyValuePairs(ObjectNode node, Shape shape) {
            if (node.isEmpty()) {
                return;
            }
            Map<Object, Object> members = shape == null ? Collections.emptyMap() : shape.members().stream().collect(Collectors.toMap(MemberShape::getMemberName, Function.identity()));
            node.getMembers().forEach((name, value) -> {
                Shape member = shape != null && shape.isMapShape() ? shape.asMapShape().get().getValue() : (shape instanceof StructureShape || shape instanceof UnionShape ? (Shape)members.get(name.getValue()) : shape);
                this.codeWriter.writeInline("\n$K: ", new Object[]{name.getValue()});
                this.serialize((Node)value, member);
            });
            this.codeWriter.write("", new Object[0]);
        }
    }

    private static final class ShapeSerializer
    extends ShapeVisitor.Default<Void> {
        private final SmithyCodeWriter codeWriter;
        private final NodeSerializer nodeSerializer;
        private final Predicate<Trait> traitFilter;
        private final Model model;
        private final Set<ShapeId> inlineableShapes;

        ShapeSerializer(SmithyCodeWriter codeWriter, NodeSerializer nodeSerializer, Predicate<Trait> traitFilter, Model model, Set<ShapeId> inlineableShapes) {
            this.codeWriter = codeWriter;
            this.nodeSerializer = nodeSerializer;
            this.traitFilter = traitFilter;
            this.model = model;
            this.inlineableShapes = inlineableShapes;
        }

        @Override
        protected Void getDefault(Shape shape) {
            this.serializeTraits(shape);
            this.codeWriter.writeInline("$L $L ", new Object[]{shape.getType(), shape.getId().getName()});
            this.writeMixins(shape);
            this.codeWriter.write("", new Object[0]).write((Object)"", new Object[0]);
            return null;
        }

        private void shapeWithMembers(Shape shape, Collection<MemberShape> members) {
            this.shapeWithMembers(shape, members, false);
        }

        private void shapeWithMembers(Shape shape, Collection<MemberShape> members, boolean isEnum) {
            ArrayList<MemberShape> nonMixinMembers = new ArrayList<MemberShape>();
            ArrayList<MemberShape> mixinMembers = new ArrayList<MemberShape>();
            for (MemberShape member : members) {
                if (member.getMixins().isEmpty()) {
                    nonMixinMembers.add(member);
                    continue;
                }
                if (member.getIntroducedTraits().isEmpty()) continue;
                mixinMembers.add(member);
            }
            this.serializeTraits(shape);
            String v2Type = shape.getType() == ShapeType.SET ? ShapeType.LIST.toString() : shape.getType().toString();
            this.codeWriter.writeInline("$L $L ", new Object[]{v2Type, shape.getId().getName()});
            this.writeMixins(shape);
            if (isEnum) {
                this.writeEnumMembers(nonMixinMembers);
            } else {
                this.writeShapeMembers(nonMixinMembers);
            }
            this.codeWriter.write("", new Object[0]);
            this.applyIntroducedTraits(mixinMembers);
        }

        private void writeMixins(Shape shape) {
            if (shape.getMixins().size() == 1) {
                this.codeWriter.writeInline("with [$I] ", new Object[]{shape.getMixins().iterator().next()});
            } else if (shape.getMixins().size() > 1) {
                this.codeWriter.write("with [", new Object[0]).indent();
                for (ShapeId id : shape.getMixins()) {
                    this.codeWriter.write("$I", new Object[]{id});
                }
                this.codeWriter.dedent().writeInline((Object)"] ", new Object[0]);
            }
        }

        private void writeShapeMembers(Collection<MemberShape> members) {
            if (members.isEmpty()) {
                this.codeWriter.writeInline("{}", new Object[0]).write((Object)"", new Object[0]);
            } else {
                this.codeWriter.openBlock("{", "}", () -> {
                    for (MemberShape member : members) {
                        this.serializeTraits(member.getAllTraits(), TraitFeature.MEMBER);
                        String assignment = "";
                        if (member.hasTrait(DefaultTrait.class)) {
                            assignment = " = " + Node.printJson(member.expectTrait(DefaultTrait.class).toNode());
                        }
                        this.codeWriter.write("$L: $I$L", new Object[]{member.getMemberName(), member.getTarget(), assignment});
                    }
                });
            }
        }

        private void writeEnumMembers(Collection<MemberShape> members) {
            if (members.isEmpty()) {
                this.codeWriter.writeInline("{}", new Object[0]).write((Object)"", new Object[0]);
                return;
            }
            this.codeWriter.openBlock("{", "}", () -> {
                for (MemberShape member : members) {
                    LinkedHashMap<ShapeId, Trait> traits = new LinkedHashMap<ShapeId, Trait>(member.getAllTraits());
                    Optional<String> stringValue = member.expectTrait(EnumValueTrait.class).getStringValue();
                    boolean hasNormalName = stringValue.isPresent() && member.getMemberName().equals(stringValue.get());
                    String assignment = "";
                    if (!hasNormalName) {
                        assignment = " = " + Node.printJson(member.expectTrait(EnumValueTrait.class).toNode());
                    }
                    traits.remove(EnumValueTrait.ID);
                    this.serializeTraits(traits, new TraitFeature[0]);
                    this.codeWriter.write("$L$L", new Object[]{member.getMemberName(), assignment});
                }
            });
        }

        private void applyIntroducedTraits(Collection<MemberShape> members) {
            for (MemberShape member : members) {
                if (member.getIntroducedTraits().size() == 1) {
                    this.codeWriter.writeInline("apply $I ", new Object[]{member.getId()});
                    this.serializeTraits(member.getIntroducedTraits(), TraitFeature.NO_SPECIAL_DOCS_SYNTAX);
                    this.codeWriter.write("", new Object[0]);
                    continue;
                }
                if (member.getIntroducedTraits().isEmpty()) continue;
                this.codeWriter.openBlock("apply $I {", "}", member.getId(), () -> this.serializeTraits(member.getIntroducedTraits(), TraitFeature.NO_SPECIAL_DOCS_SYNTAX)).write((Object)"", new Object[0]);
            }
        }

        private void serializeTraits(Shape shape) {
            this.serializeTraits(shape.getIntroducedTraits(), new TraitFeature[0]);
        }

        private void serializeTraits(Map<ShapeId, Trait> traits, TraitFeature ... traitFeatures) {
            Trait documentation;
            boolean noSpecialDocsSyntax = TraitFeature.NO_SPECIAL_DOCS_SYNTAX.hasFeature(traitFeatures);
            boolean isMember = TraitFeature.MEMBER.hasFeature(traitFeatures);
            if (!noSpecialDocsSyntax && traits.containsKey(DocumentationTrait.ID) && this.traitFilter.test(documentation = traits.get(DocumentationTrait.ID))) {
                this.serializeDocumentation(documentation.toNode().expectStringNode().getValue());
            }
            traits.values().stream().filter(trait -> noSpecialDocsSyntax || !(trait instanceof DocumentationTrait)).filter(trait -> {
                if (trait instanceof EnumValueTrait) {
                    return false;
                }
                return !isMember || !(trait instanceof DefaultTrait);
            }).filter(this.traitFilter).sorted(Comparator.comparing(Trait::toShapeId)).forEach(this::serializeTrait);
        }

        private void serializeDocumentation(String documentation) {
            this.codeWriter.setNewlinePrefix("/// ").write((Object)documentation.replace("$", "$$"), new Object[0]).setNewlinePrefix("");
        }

        private void serializeTrait(Trait trait) {
            Node node = trait.toNode();
            Shape shape = this.model.expectShape(trait.toShapeId());
            if (trait instanceof AnnotationTrait || this.isEmptyStructure(node, shape)) {
                this.codeWriter.write("@$I", new Object[]{trait.toShapeId()});
            } else if (node.isObjectNode()) {
                this.codeWriter.writeIndent().openBlockInline("@$I(", new Object[]{trait.toShapeId()});
                this.nodeSerializer.serializeKeyValuePairs(node.expectObjectNode(), shape);
                this.codeWriter.closeBlock(")", new Object[0]);
            } else {
                this.codeWriter.writeIndent().writeInline("@$I(", new Object[]{trait.toShapeId()});
                this.nodeSerializer.serialize(node, shape);
                this.codeWriter.write(")", new Object[0]);
            }
        }

        private boolean isEmptyStructure(Node node, Shape shape) {
            return !shape.isDocumentShape() && node.asObjectNode().map(ObjectNode::isEmpty).orElse(false) != false;
        }

        @Override
        public Void enumShape(EnumShape shape) {
            this.shapeWithMembers(shape, shape.members(), true);
            return null;
        }

        @Override
        public Void intEnumShape(IntEnumShape shape) {
            this.shapeWithMembers(shape, shape.members(), true);
            return null;
        }

        @Override
        public Void listShape(ListShape shape) {
            this.shapeWithMembers(shape, Collections.singletonList(shape.getMember()));
            return null;
        }

        @Override
        public Void mapShape(MapShape shape) {
            this.shapeWithMembers(shape, ListUtils.of((Object)shape.getKey(), (Object)shape.getValue()));
            return null;
        }

        @Override
        public Void structureShape(StructureShape shape) {
            this.shapeWithMembers(shape, shape.members());
            return null;
        }

        @Override
        public Void unionShape(UnionShape shape) {
            this.shapeWithMembers(shape, shape.members());
            return null;
        }

        @Override
        public Void serviceShape(ServiceShape shape) {
            this.serializeTraits(shape);
            this.codeWriter.writeInline("service $L ", new Object[]{shape.getId().getName()});
            this.writeMixins(shape);
            this.codeWriter.openBlock("{", new Object[0]);
            if (!StringUtils.isBlank((CharSequence)shape.getIntroducedVersion())) {
                this.codeWriter.write("version: $S", new Object[]{shape.getIntroducedVersion()});
            }
            this.codeWriter.writeOptionalIdList("operations", shape.getIntroducedOperations());
            this.codeWriter.writeOptionalIdList("resources", shape.getIntroducedResources());
            this.codeWriter.writeOptionalIdList("errors", shape.getIntroducedErrors());
            if (!shape.getIntroducedRename().isEmpty()) {
                this.codeWriter.openBlock("rename: {", "}", () -> {
                    for (Map.Entry<ShapeId, String> entry : shape.getIntroducedRename().entrySet()) {
                        this.codeWriter.write("$S: $S", new Object[]{entry.getKey(), entry.getValue()});
                    }
                });
            }
            this.codeWriter.closeBlock("}", new Object[0]).write((Object)"", new Object[0]);
            return null;
        }

        @Override
        public Void resourceShape(ResourceShape shape) {
            this.serializeTraits(shape);
            this.codeWriter.writeInline("resource $L ", new Object[]{shape.getId().getName()});
            this.writeMixins(shape);
            this.codeWriter.openBlock("{", new Object[0]);
            if (!shape.getIdentifiers().isEmpty()) {
                this.codeWriter.openBlock("identifiers: {", new Object[0]);
                shape.getIdentifiers().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> this.codeWriter.write("$L: $I", new Object[]{entry.getKey(), entry.getValue()}));
                this.codeWriter.closeBlock("}", new Object[0]);
            }
            shape.getPut().ifPresent(shapeId -> this.codeWriter.write("put: $I", new Object[]{shapeId}));
            shape.getCreate().ifPresent(shapeId -> this.codeWriter.write("create: $I", new Object[]{shapeId}));
            shape.getRead().ifPresent(shapeId -> this.codeWriter.write("read: $I", new Object[]{shapeId}));
            shape.getUpdate().ifPresent(shapeId -> this.codeWriter.write("update: $I", new Object[]{shapeId}));
            shape.getDelete().ifPresent(shapeId -> this.codeWriter.write("delete: $I", new Object[]{shapeId}));
            shape.getList().ifPresent(shapeId -> this.codeWriter.write("list: $I", new Object[]{shapeId}));
            this.codeWriter.writeOptionalIdList("operations", shape.getIntroducedOperations());
            this.codeWriter.writeOptionalIdList("collectionOperations", shape.getCollectionOperations());
            this.codeWriter.writeOptionalIdList("resources", shape.getIntroducedResources());
            this.codeWriter.closeBlock("}", new Object[0]);
            this.codeWriter.write("", new Object[0]);
            return null;
        }

        @Override
        public Void operationShape(OperationShape shape) {
            this.serializeTraits(shape);
            this.codeWriter.writeInline("operation $L ", new Object[]{shape.getId().getName()});
            this.writeMixins(shape);
            this.codeWriter.openBlock("{", new Object[0]);
            ArrayList<MemberShape> mixinMembers = new ArrayList<MemberShape>();
            mixinMembers.addAll(this.writeInlineableProperty("input", shape.getInputShape(), InputTrait.ID));
            mixinMembers.addAll(this.writeInlineableProperty("output", shape.getOutputShape(), OutputTrait.ID));
            this.codeWriter.writeOptionalIdList("errors", shape.getIntroducedErrors());
            this.codeWriter.closeBlock("}", new Object[0]);
            this.codeWriter.write("", new Object[0]);
            this.applyIntroducedTraits(mixinMembers);
            return null;
        }

        private Collection<MemberShape> writeInlineableProperty(String key, ShapeId shapeId, ShapeId defaultTrait) {
            if (!this.inlineableShapes.contains(shapeId)) {
                this.codeWriter.write("$L: $I", new Object[]{key, shapeId});
                return Collections.emptyList();
            }
            StructureShape structure = this.model.expectShape(shapeId, StructureShape.class);
            if (this.hasOnlyDefaultTrait(structure, defaultTrait)) {
                this.codeWriter.writeInline("$L := ", new Object[]{key});
            } else {
                this.codeWriter.write("$L := ", new Object[]{key});
                this.codeWriter.indent();
                Map<ShapeId, Trait> traits = structure.getAllTraits();
                if (defaultTrait != null) {
                    traits = new HashMap<ShapeId, Trait>(traits);
                    traits.remove(defaultTrait);
                }
                this.serializeTraits(traits, new TraitFeature[0]);
            }
            ArrayList<MemberShape> nonMixinMembers = new ArrayList<MemberShape>();
            ArrayList<MemberShape> mixinMembers = new ArrayList<MemberShape>();
            for (MemberShape member : structure.members()) {
                if (member.getMixins().isEmpty()) {
                    nonMixinMembers.add(member);
                    continue;
                }
                if (member.getIntroducedTraits().isEmpty()) continue;
                mixinMembers.add(member);
            }
            this.writeMixins(structure);
            this.writeShapeMembers(nonMixinMembers);
            if (!this.hasOnlyDefaultTrait(structure, defaultTrait)) {
                this.codeWriter.dedent();
            }
            return mixinMembers;
        }

        private boolean hasOnlyDefaultTrait(Shape shape, ShapeId defaultTrait) {
            return shape.getAllTraits().size() == 1 && shape.hasTrait(defaultTrait);
        }
    }

    public static final class Builder
    implements SmithyBuilder<SmithyIdlModelSerializer> {
        private Predicate<String> metadataFilter = FunctionalUtils.alwaysTrue();
        private Predicate<Shape> shapeFilter = FunctionalUtils.alwaysTrue();
        private Predicate<Trait> traitFilter = FunctionalUtils.alwaysTrue();
        private Function<Shape, Path> shapePlacer = SmithyIdlModelSerializer::placeShapesByNamespace;
        private Path basePath = null;
        private boolean serializePrelude = false;

        public Builder metadataFilter(Predicate<String> metadataFilter) {
            this.metadataFilter = Objects.requireNonNull(metadataFilter);
            return this;
        }

        public Builder shapeFilter(Predicate<Shape> shapeFilter) {
            this.shapeFilter = Objects.requireNonNull(shapeFilter);
            return this;
        }

        public Builder traitFilter(Predicate<Trait> traitFilter) {
            this.traitFilter = traitFilter;
            return this;
        }

        public Builder shapePlacer(Function<Shape, Path> shapePlacer) {
            this.shapePlacer = Objects.requireNonNull(shapePlacer);
            return this;
        }

        public Builder basePath(Path basePath) {
            this.basePath = basePath;
            return this;
        }

        public Builder serializePrelude() {
            this.serializePrelude = true;
            return this;
        }

        public SmithyIdlModelSerializer build() {
            return new SmithyIdlModelSerializer(this);
        }
    }

    private static final class ShapeComparator
    implements Comparator<Shape>,
    Serializable {
        private static final Map<ShapeType, Integer> PRIORITY = MapUtils.of((Object)((Object)ShapeType.SERVICE), (Object)0, (Object)((Object)ShapeType.RESOURCE), (Object)1, (Object)((Object)ShapeType.OPERATION), (Object)2, (Object)((Object)ShapeType.STRUCTURE), (Object)3, (Object)((Object)ShapeType.UNION), (Object)4, (Object)((Object)ShapeType.LIST), (Object)5, (Object)((Object)ShapeType.SET), (Object)6, (Object)((Object)ShapeType.MAP), (Object)7);

        private ShapeComparator() {
        }

        @Override
        public int compare(Shape s1, Shape s2) {
            if (s1.hasTrait(TraitDefinition.class) || s2.hasTrait(TraitDefinition.class)) {
                if (!s1.hasTrait(TraitDefinition.class)) {
                    return 1;
                }
                if (!s2.hasTrait(TraitDefinition.class)) {
                    return -1;
                }
                return s1.compareTo(s2);
            }
            if (s1.getType().equals((Object)s2.getType())) {
                return s1.compareTo(s2);
            }
            if (PRIORITY.containsKey((Object)s1.getType()) || PRIORITY.containsKey((Object)s2.getType())) {
                if (!PRIORITY.containsKey((Object)s1.getType())) {
                    return 1;
                }
                if (!PRIORITY.containsKey((Object)s2.getType())) {
                    return -1;
                }
                return PRIORITY.get((Object)s1.getType()) - PRIORITY.get((Object)s2.getType());
            }
            return s1.compareTo(s2);
        }
    }

    private static enum TraitFeature {
        NO_SPECIAL_DOCS_SYNTAX,
        MEMBER;


        boolean hasFeature(TraitFeature[] haystack) {
            for (TraitFeature test : haystack) {
                if (test != this) continue;
                return true;
            }
            return false;
        }
    }
}

