/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.BooleanNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeVisitor;
import software.amazon.smithy.model.node.NumberNode;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.selector.AttributeValue;
import software.amazon.smithy.model.selector.SelectorException;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.Trait;

final class AttributeValueImpl {
    static final AttributeValue EMPTY = new AttributeValue(){

        @Override
        public String toString() {
            return "";
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public AttributeValue getProperty(String key) {
            return EMPTY;
        }
    };
    private static final Logger LOGGER = Logger.getLogger(AttributeValue.class.getName());
    private static final String KEYS = "(keys)";
    private static final String VALUES = "(values)";
    private static final String LENGTH = "(length)";
    private static final String FIRST = "(first)";

    private AttributeValueImpl() {
    }

    static final class VariableValue
    implements AttributeValue {
        private final Map<String, Set<Shape>> vars;

        VariableValue(Map<String, Set<Shape>> vars) {
            this.vars = vars;
        }

        @Override
        public String toString() {
            return "";
        }

        @Override
        public AttributeValue getProperty(String property) {
            Set shapes = this.vars.getOrDefault(property, Collections.emptySet());
            ArrayList<AttributeValue> values = new ArrayList<AttributeValue>(shapes.size());
            for (Shape shape : shapes) {
                values.add(AttributeValue.shape(shape, this.vars));
            }
            return AttributeValue.projection(values);
        }
    }

    static final class ShapeValue
    implements AttributeValue {
        private final Shape shape;
        private final Map<String, Set<Shape>> vars;

        ShapeValue(Shape shape, Map<String, Set<Shape>> vars) {
            this.shape = Objects.requireNonNull(shape);
            this.vars = vars == null ? Collections.emptyMap() : vars;
        }

        @Override
        public String toString() {
            return this.shape.getId().toString();
        }

        @Override
        public AttributeValue getProperty(String property) {
            switch (property) {
                case "trait": {
                    return new Traits(this.shape);
                }
                case "id": {
                    return AttributeValue.id(this.shape.getId());
                }
                case "service": {
                    return this.shape.asServiceShape().map(Service::new).orElse(EMPTY);
                }
                case "var": {
                    return new VariableValue(this.vars);
                }
            }
            throw new SelectorException("Invalid shape selector attribute: " + property);
        }
    }

    static final class Traits
    implements AttributeValue {
        private final Shape shape;

        Traits(Shape shape) {
            this.shape = Objects.requireNonNull(shape);
        }

        @Override
        public String toString() {
            return "";
        }

        @Override
        public AttributeValue getProperty(String property) {
            switch (property) {
                case "(keys)": {
                    ArrayList<AttributeValue> keyValues = new ArrayList<AttributeValue>();
                    for (ShapeId id : this.shape.getAllTraits().keySet()) {
                        keyValues.add(AttributeValue.id(id));
                    }
                    return AttributeValue.projection(keyValues);
                }
                case "(values)": {
                    ArrayList<AttributeValue> values = new ArrayList<AttributeValue>();
                    for (Trait trait2 : this.shape.getAllTraits().values()) {
                        values.add(new NodeValue(trait2.toNode()));
                    }
                    return AttributeValue.projection(values);
                }
                case "(length)": {
                    return AttributeValue.literal(this.shape.getAllTraits().size());
                }
            }
            return this.shape.findTrait(ShapeId.from(Trait.makeAbsoluteName(property))).map(trait -> new NodeValue(trait.toNode())).orElse(EMPTY);
        }
    }

    static final class Id
    implements AttributeValue {
        private final ShapeId id;

        Id(ShapeId id) {
            this.id = id;
        }

        @Override
        public String toString() {
            return this.id.toString();
        }

        @Override
        public AttributeValue getProperty(String property) {
            switch (property) {
                case "name": {
                    return AttributeValue.literal(this.id.getName());
                }
                case "namespace": {
                    return AttributeValue.literal(this.id.getNamespace());
                }
                case "member": {
                    return this.id.getMember().map(Literal::new).orElse(EMPTY);
                }
                case "(length)": {
                    return AttributeValue.literal(this.id.toString().length());
                }
            }
            throw new SelectorException("Invalid nested 'id' selector attribute property: " + property);
        }
    }

    static final class Service
    implements AttributeValue {
        private final ServiceShape service;

        Service(ServiceShape service) {
            this.service = service;
        }

        @Override
        public String toString() {
            return this.service.getId().toString();
        }

        @Override
        public AttributeValue getProperty(String key) {
            if (key.equals("version")) {
                return AttributeValue.literal(this.service.getVersion());
            }
            if (key.equals("id")) {
                return AttributeValue.id(this.service.getId());
            }
            throw new SelectorException("Invalid nested 'service' selector attribute property: " + key);
        }
    }

    static final class Projection
    implements AttributeValue {
        private final Collection<? extends AttributeValue> values;
        private Collection<? extends AttributeValue> flattened;
        private String messageString;

        Projection(Collection<? extends AttributeValue> values) {
            this.values = values;
        }

        @Override
        public AttributeValue getProperty(String key) {
            if (key.equals(AttributeValueImpl.FIRST)) {
                return this.values.isEmpty() ? EMPTY : this.getFlattenedValues().iterator().next();
            }
            ArrayList<AttributeValue> result = new ArrayList<AttributeValue>();
            for (AttributeValue attributeValue : this.values) {
                AttributeValue next = attributeValue.getProperty(key);
                if (!next.isPresent()) continue;
                result.add(next);
            }
            return AttributeValue.projection(result);
        }

        @Override
        public String toMessageString() {
            String str = this.messageString;
            if (str == null) {
                this.messageString = str = this.getFlattenedValues().stream().map(AttributeValue::toMessageString).sorted().collect(Collectors.joining(", ", "[", "]"));
            }
            return str;
        }

        @Override
        public Collection<? extends AttributeValue> getFlattenedValues() {
            if (this.flattened == null) {
                ArrayList<? extends AttributeValue> result = new ArrayList<AttributeValue>(this.values.size());
                for (AttributeValue attributeValue : this.values) {
                    if (attributeValue instanceof Projection) {
                        result.addAll(((Projection)attributeValue).getFlattenedValues());
                        continue;
                    }
                    result.add(attributeValue);
                }
                this.flattened = result;
            }
            return this.flattened;
        }

        @Override
        public String toString() {
            return "";
        }

        @Override
        public boolean isPresent() {
            return !this.values.isEmpty();
        }
    }

    static final class NodeValue
    implements AttributeValue {
        private static final NodeVisitor<String> TO_STRING = new NodeToString();
        private final Node value;
        private String asString;
        private String messageString;

        NodeValue(Node value) {
            this.value = value;
        }

        @Override
        public boolean isPresent() {
            return !this.value.isNullNode();
        }

        @Override
        public String toString() {
            String str = this.asString;
            if (str == null) {
                this.asString = str = this.value.accept(TO_STRING);
            }
            return str;
        }

        @Override
        public String toMessageString() {
            String str = this.messageString;
            if (str == null) {
                this.messageString = str = Node.printJson(this.value);
            }
            return str;
        }

        @Override
        public AttributeValue getProperty(String key) {
            switch (this.value.getType()) {
                case OBJECT: {
                    ObjectNode objectNode = this.value.expectObjectNode();
                    switch (key) {
                        case "(keys)": {
                            return this.project(objectNode.getMembers().keySet());
                        }
                        case "(values)": {
                            return this.project(objectNode.getMembers().values());
                        }
                        case "(length)": {
                            return AttributeValue.literal(objectNode.getMembers().size());
                        }
                    }
                    return this.value.expectObjectNode().getMember(key).map(NodeValue::new).orElse(EMPTY);
                }
                case ARRAY: {
                    ArrayNode arrayNode = this.value.expectArrayNode();
                    switch (key) {
                        case "(values)": {
                            return this.project(arrayNode.getElements());
                        }
                        case "(length)": {
                            return AttributeValue.literal(arrayNode.size());
                        }
                    }
                    return EMPTY;
                }
                case STRING: {
                    if (!key.equals(AttributeValueImpl.LENGTH)) break;
                    return AttributeValue.literal(this.value.expectStringNode().getValue().length());
                }
            }
            return EMPTY;
        }

        private AttributeValue project(Collection<? extends Node> nodes) {
            ArrayList<AttributeValue> values = new ArrayList<AttributeValue>(nodes.size());
            for (Node node : nodes) {
                values.add(AttributeValue.node(node));
            }
            return AttributeValue.projection(values);
        }

        private static final class NodeToString
        extends NodeVisitor.Default<String> {
            private NodeToString() {
            }

            @Override
            protected String getDefault(Node node) {
                return "";
            }

            @Override
            public String stringNode(StringNode node) {
                return node.getValue();
            }

            @Override
            public String numberNode(NumberNode node) {
                return node.getValue().toString();
            }

            @Override
            public String booleanNode(BooleanNode node) {
                return Boolean.toString(node.getValue());
            }
        }
    }

    static final class Literal
    implements AttributeValue {
        private final Object value;

        Literal(Object value) {
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public String toString() {
            return this.value.toString();
        }

        @Override
        public AttributeValue getProperty(String key) {
            if (key.equals(AttributeValueImpl.LENGTH)) {
                return AttributeValue.literal(this.toString().length());
            }
            return EMPTY;
        }
    }
}

