/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.ExpectationNotMetException;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;

final class LoaderUtils {
    private LoaderUtils() {
    }

    static Optional<ValidationEvent> checkForAdditionalProperties(ObjectNode node, ShapeId shape, Collection<String> properties) {
        try {
            node.expectNoAdditionalProperties(properties);
            return Optional.empty();
        }
        catch (ExpectationNotMetException e) {
            ValidationEvent event = ValidationEvent.fromSourceException(e).toBuilder().shapeId(shape).severity(Severity.WARNING).build();
            return Optional.of(event);
        }
    }

    static ValidationEvent onShapeConflict(ShapeId id, SourceLocation a, SourceLocation b, String message) {
        String formatted = String.format("Conflicting shape definition for `%s` found at `%s` and `%s`", id, a, b);
        if (message != null) {
            formatted = formatted + ". " + message;
        }
        return ValidationEvent.builder().id("Model").severity(Severity.ERROR).sourceLocation(b).shapeId(id).message(formatted).build();
    }

    static boolean isSameLocation(FromSourceLocation a, FromSourceLocation b) {
        SourceLocation sa = a.getSourceLocation();
        SourceLocation sb = b.getSourceLocation();
        return sa != SourceLocation.NONE && sa.equals(sb);
    }

    static boolean containsErrorEvents(List<ValidationEvent> events) {
        for (ValidationEvent event : events) {
            if (event.getSeverity() != Severity.ERROR) continue;
            return true;
        }
        return false;
    }
}

