/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.ApplyMixin;
import software.amazon.smithy.model.loader.ApplyResourceBasedTargets;
import software.amazon.smithy.model.loader.AstModelLoader;
import software.amazon.smithy.model.loader.IdlNodeParser;
import software.amazon.smithy.model.loader.IdlTraitParser;
import software.amazon.smithy.model.loader.LoadOperation;
import software.amazon.smithy.model.loader.LoaderUtils;
import software.amazon.smithy.model.loader.ModelSyntaxException;
import software.amazon.smithy.model.loader.ParserUtils;
import software.amazon.smithy.model.loader.Version;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NumberNode;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.BigDecimalShape;
import software.amazon.smithy.model.shapes.BigIntegerShape;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.BooleanShape;
import software.amazon.smithy.model.shapes.ByteShape;
import software.amazon.smithy.model.shapes.CollectionShape;
import software.amazon.smithy.model.shapes.DocumentShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.EnumShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.IntEnumShape;
import software.amazon.smithy.model.shapes.IntegerShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.LongShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ShortShape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.DefaultTrait;
import software.amazon.smithy.model.traits.DocumentationTrait;
import software.amazon.smithy.model.traits.EnumValueTrait;
import software.amazon.smithy.model.traits.InputTrait;
import software.amazon.smithy.model.traits.OutputTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.UnitTypeTrait;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SimpleParser;
import software.amazon.smithy.utils.StringUtils;

final class IdlModelParser
extends SimpleParser {
    private static final int MAX_NESTING_LEVEL = 250;
    private static final String PUT_KEY = "put";
    private static final String CREATE_KEY = "create";
    private static final String READ_KEY = "read";
    private static final String UPDATE_KEY = "update";
    private static final String DELETE_KEY = "delete";
    private static final String LIST_KEY = "list";
    private static final String RESOURCES_KEY = "resources";
    private static final String OPERATIONS_KEY = "operations";
    private static final String PROPERTIES_KEY = "properties";
    private static final String RENAME_KEY = "rename";
    private static final String COLLECTION_OPERATIONS_KEY = "collectionOperations";
    private static final String IDENTIFIERS_KEY = "identifiers";
    private static final String VERSION_KEY = "version";
    private static final String TYPE_KEY = "type";
    private static final String ERRORS_KEY = "errors";
    static final Collection<String> RESOURCE_PROPERTY_NAMES = ListUtils.of((Object[])new String[]{"type", "create", "read", "update", "delete", "list", "identifiers", "resources", "operations", "put", "properties", "collectionOperations"});
    static final List<String> SERVICE_PROPERTY_NAMES = ListUtils.of((Object[])new String[]{"type", "version", "operations", "resources", "rename", "errors"});
    private static final Set<String> SHAPE_TYPES = new HashSet<String>();
    private final String filename;
    private final Map<String, ShapeId> useShapes = new HashMap<String, ShapeId>();
    private Consumer<LoadOperation> operations;
    private Version modelVersion = Version.VERSION_1_0;
    private String namespace;
    private TraitEntry pendingDocumentationComment;
    private boolean emittedVersion = false;
    private String operationInputSuffix = "Input";
    private String operationOutputSuffix = "Output";

    IdlModelParser(String filename, String model) {
        super(model, 250);
        this.filename = filename;
    }

    void parse(Consumer<LoadOperation> operationConsumer) {
        this.operations = operationConsumer;
        this.ws();
        this.parseControlSection();
        if (!this.emittedVersion) {
            this.operations.accept(new LoadOperation.ModelVersion(this.modelVersion, this.currentLocation()));
        }
        this.parseMetadataSection();
        this.parseShapeSection();
    }

    LoadOperation.DefineShape createShape(AbstractShapeBuilder<?, ?> builder) {
        return new LoadOperation.DefineShape(this.modelVersion, builder);
    }

    void addOperation(LoadOperation operation) {
        this.operations.accept(operation);
    }

    void emit(ValidationEvent event) {
        this.addOperation(new LoadOperation.Event(event));
    }

    void addForwardReference(String id, BiConsumer<ShapeId, Function<ShapeId, ShapeType>> consumer) {
        int memberPosition = id.indexOf(36);
        if (memberPosition > 0 && memberPosition < id.length() - 1) {
            this.addForwardReference(id.substring(0, memberPosition), (ShapeId resolved, Function<ShapeId, ShapeType> type) -> consumer.accept(resolved.withMember(id.substring(memberPosition + 1)), (Function<ShapeId, ShapeType>)type));
        } else {
            String resolved2 = this.useShapes.containsKey(id) ? this.useShapes.get(id).toString() : id;
            this.addOperation(new LoadOperation.ForwardReference(this.namespace, resolved2, consumer));
        }
    }

    void addForwardReference(String id, Consumer<ShapeId> consumer) {
        this.addForwardReference(id, (ShapeId resolved, Function<ShapeId, ShapeType> found) -> consumer.accept((ShapeId)resolved));
    }

    String expectNamespace() {
        if (this.namespace == null) {
            throw new IllegalStateException("No namespace was set before trying to resolve a forward reference");
        }
        return this.namespace;
    }

    public void ws() {
        block4: while (!this.eof()) {
            switch (this.peek()) {
                case '/': {
                    if (this.peekDocComment()) {
                        this.parseDocComment();
                        continue block4;
                    }
                    this.parseComment();
                    continue block4;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': {
                    this.skip();
                    continue block4;
                }
            }
            return;
        }
    }

    private void rsp() {
        int cc = this.column();
        this.sp();
        if (this.column() == cc) {
            throw this.syntax("Expected one or more spaces");
        }
    }

    private void rws() {
        int line = this.line();
        int column = this.column();
        this.ws();
        if (this.line() == line && column == this.column()) {
            throw this.syntax("Expected one or more whitespace characters");
        }
    }

    public void sp() {
        while (this.isSpaceOrComma(this.peek())) {
            this.skip();
        }
    }

    private boolean isSpaceOrComma(char c) {
        return c == ' ' || c == '\t' || c == ',';
    }

    public void br() {
        int line = this.line();
        this.ws();
        if (line == this.line() && !this.eof()) {
            throw this.syntax("Expected a line break");
        }
    }

    public ModelSyntaxException syntax(String message) {
        return this.syntax(null, message);
    }

    ModelSyntaxException syntax(ShapeId shapeId, String message) {
        return ModelSyntaxException.builder().message(String.format("Parse error at line %d, column %d near `%s`: %s", this.line(), this.column(), this.peekDebugMessage(), message)).sourceLocation(this.filename, this.line(), this.column()).shapeId(shapeId).build();
    }

    private void parseControlSection() {
        HashSet<String> definedKeys = new HashSet<String>();
        while (this.peek() == '$') {
            this.expect('$');
            String key = IdlNodeParser.parseNodeObjectKey(this);
            this.sp();
            this.expect(':');
            this.sp();
            if (definedKeys.contains(key)) {
                throw this.syntax(String.format("Duplicate control statement `%s`", key));
            }
            definedKeys.add(key);
            Node value = IdlNodeParser.parseNode(this);
            switch (key) {
                case "version": {
                    this.onVersion(value);
                    break;
                }
                case "operationInputSuffix": {
                    this.operationInputSuffix = value.expectStringNode().getValue();
                    break;
                }
                case "operationOutputSuffix": {
                    this.operationOutputSuffix = value.expectStringNode().getValue();
                    break;
                }
                default: {
                    this.emit(ValidationEvent.builder().id("Model").sourceLocation(value).severity(Severity.WARNING).message(String.format("Unknown control statement `%s` with value `%s", key, Node.printJson(value))).build());
                }
            }
            this.br();
        }
    }

    private void onVersion(Node value) {
        String parsedVersion;
        Version resolvedVersion;
        if (!value.isStringNode()) {
            value.expectStringNode(() -> "The $version control statement must have a string value, but found " + Node.printJson(value));
        }
        if ((resolvedVersion = Version.fromString(parsedVersion = value.expectStringNode().getValue())) == null) {
            throw this.syntax("Unsupported Smithy version number: " + parsedVersion);
        }
        this.emittedVersion = true;
        this.modelVersion = resolvedVersion;
        this.operations.accept(new LoadOperation.ModelVersion(this.modelVersion, value.getSourceLocation()));
    }

    private void parseMetadataSection() {
        while (this.peek() == 'm') {
            this.expect('m');
            this.expect('e');
            this.expect('t');
            this.expect('a');
            this.expect('d');
            this.expect('a');
            this.expect('t');
            this.expect('a');
            this.rsp();
            String key = IdlNodeParser.parseNodeObjectKey(this);
            this.sp();
            this.expect('=');
            this.sp();
            this.operations.accept(new LoadOperation.PutMetadata(this.modelVersion, key, IdlNodeParser.parseNode(this)));
            this.br();
        }
    }

    private void parseShapeSection() {
        if (this.peek() == 'n') {
            this.expect('n');
            this.expect('a');
            this.expect('m');
            this.expect('e');
            this.expect('s');
            this.expect('p');
            this.expect('a');
            this.expect('c');
            this.expect('e');
            this.rsp();
            int start = this.position();
            ParserUtils.consumeNamespace(this);
            this.namespace = this.sliceFrom(start);
            this.clearPendingDocs();
            this.br();
            this.parseUseSection();
            this.parseShapeStatements();
        } else if (!this.eof()) {
            if (!ParserUtils.isIdentifierStart(this.peek())) {
                throw this.syntax("Expected a namespace definition, but found unexpected syntax");
            }
            throw this.syntax("A namespace must be defined before a use statement or shapes");
        }
    }

    private void parseUseSection() {
        while (this.peek() == 'u' && this.peek(1) == 's') {
            this.expect('u');
            this.expect('s');
            this.expect('e');
            this.rsp();
            int start = this.position();
            SourceLocation location = this.currentLocation();
            ParserUtils.consumeNamespace(this);
            this.expect('#');
            ParserUtils.consumeIdentifier(this);
            String lexeme = this.sliceFrom(start);
            this.clearPendingDocs();
            this.br();
            ShapeId target = ShapeId.from(lexeme);
            this.addForwardReference(lexeme, (ShapeId resolved, Function<ShapeId, ShapeType> typeProvider) -> {
                if (typeProvider.apply(resolved) == null) {
                    ValidationEvent event = ValidationEvent.builder().id("Model").severity(Severity.WARNING).sourceLocation(location).message("Use statement refers to undefined shape: " + lexeme).build();
                    this.emit(event);
                }
            });
            this.useShape(target, location);
        }
    }

    void useShape(ShapeId id, SourceLocation location) {
        if (this.useShapes.containsKey(id.getName())) {
            ShapeId previous = this.useShapes.get(id.getName());
            String message = String.format("Cannot use name `%s` because it conflicts with `%s`", id, previous);
            throw new ModelSyntaxException(message, location);
        }
        this.useShapes.put(id.getName(), id);
    }

    private void parseShapeStatements() {
        while (!this.eof()) {
            boolean docsOnly;
            if (this.peek() == 'a') {
                this.parseApplyStatement();
                continue;
            }
            boolean bl = docsOnly = this.pendingDocumentationComment != null;
            List<TraitEntry> traits = this.parseDocsAndTraits();
            if (!this.parseShapeDefinition(traits, docsOnly)) continue;
            this.parseShape(traits);
        }
    }

    private void clearPendingDocs() {
        this.pendingDocumentationComment = null;
    }

    private boolean parseShapeDefinition(List<TraitEntry> traits, boolean docsOnly) {
        if (this.eof()) {
            return !traits.isEmpty() && !docsOnly;
        }
        return true;
    }

    private List<TraitEntry> parseDocsAndTraits() {
        TraitEntry docComment = this.pendingDocumentationComment;
        this.clearPendingDocs();
        this.ws();
        List<TraitEntry> traits = IdlTraitParser.parseTraits(this);
        if (docComment != null) {
            traits.add(docComment);
        }
        this.ws();
        return traits;
    }

    private void parseShape(List<TraitEntry> traits) {
        SourceLocation location = this.currentLocation();
        String shapeType = ParserUtils.parseIdentifier(this);
        if (!SHAPE_TYPES.contains(shapeType)) {
            switch (shapeType) {
                case "use": {
                    throw this.syntax("A use statement must come before any shape definition");
                }
                case "namespace": {
                    throw this.syntax("Only a single namespace can be declared per/file");
                }
                case "metadata": {
                    throw this.syntax("Metadata statements must appear before a namespace statement");
                }
            }
            throw this.syntax("Unexpected shape type: " + shapeType);
        }
        this.rsp();
        ShapeId id = this.parseShapeName();
        switch (shapeType) {
            case "service": {
                this.parseServiceStatement(id, location);
                break;
            }
            case "resource": {
                this.parseResourceStatement(id, location);
                break;
            }
            case "operation": {
                this.parseOperationStatement(id, location);
                break;
            }
            case "structure": {
                this.parseStructuredShape(id, location, StructureShape.builder(), MemberParsing.PARSING_STRUCTURE_MEMBER);
                break;
            }
            case "union": {
                this.parseStructuredShape(id, location, UnionShape.builder(), MemberParsing.PARSING_MEMBER);
                break;
            }
            case "list": {
                this.parseCollection(id, location, ListShape.builder());
                break;
            }
            case "set": {
                this.parseCollection(id, location, SetShape.builder());
                break;
            }
            case "map": {
                this.parseMapStatement(id, location);
                break;
            }
            case "boolean": {
                this.parseSimpleShape(id, location, BooleanShape.builder());
                break;
            }
            case "string": {
                this.parseSimpleShape(id, location, StringShape.builder());
                break;
            }
            case "enum": {
                this.parseEnumShape(id, location, EnumShape.builder());
                break;
            }
            case "blob": {
                this.parseSimpleShape(id, location, BlobShape.builder());
                break;
            }
            case "byte": {
                this.parseSimpleShape(id, location, ByteShape.builder());
                break;
            }
            case "short": {
                this.parseSimpleShape(id, location, ShortShape.builder());
                break;
            }
            case "integer": {
                this.parseSimpleShape(id, location, IntegerShape.builder());
                break;
            }
            case "intEnum": {
                this.parseEnumShape(id, location, IntEnumShape.builder());
                break;
            }
            case "long": {
                this.parseSimpleShape(id, location, LongShape.builder());
                break;
            }
            case "float": {
                this.parseSimpleShape(id, location, FloatShape.builder());
                break;
            }
            case "document": {
                this.parseSimpleShape(id, location, DocumentShape.builder());
                break;
            }
            case "double": {
                this.parseSimpleShape(id, location, DoubleShape.builder());
                break;
            }
            case "bigInteger": {
                this.parseSimpleShape(id, location, BigIntegerShape.builder());
                break;
            }
            case "bigDecimal": {
                this.parseSimpleShape(id, location, BigDecimalShape.builder());
                break;
            }
            case "timestamp": {
                this.parseSimpleShape(id, location, TimestampShape.builder());
                break;
            }
            default: {
                throw this.syntax(id, "Unexpected shape type: " + shapeType);
            }
        }
        this.addTraits(id, traits);
        this.clearPendingDocs();
        this.br();
    }

    private ShapeId parseShapeName() {
        SourceLocation currentLocation = this.currentLocation();
        String name = ParserUtils.parseIdentifier(this);
        ShapeId id = ShapeId.fromRelative(this.expectNamespace(), name);
        if (this.useShapes.containsKey(name)) {
            ShapeId previous = this.useShapes.get(name);
            String message = String.format("Shape name `%s` conflicts with imported shape `%s`", name, previous);
            throw new ModelSyntaxException(message, currentLocation);
        }
        return id;
    }

    private void parseSimpleShape(ShapeId id, SourceLocation location, AbstractShapeBuilder<?, ?> builder) {
        LoadOperation.DefineShape operation = this.createShape((AbstractShapeBuilder<?, ?>)((AbstractShapeBuilder)builder.source(location)).id(id));
        this.parseMixins(operation);
        this.operations.accept(operation);
    }

    private void parseEnumShape(ShapeId id, SourceLocation location, AbstractShapeBuilder<?, ?> builder) {
        LoadOperation.DefineShape operation = this.createShape((AbstractShapeBuilder<?, ?>)((AbstractShapeBuilder)builder.id(id)).source(location));
        this.parseMixins(operation);
        this.ws();
        this.expect('{');
        this.clearPendingDocs();
        this.ws();
        while (!this.eof() && this.peek() != '}') {
            List<TraitEntry> memberTraits = this.parseDocsAndTraits();
            SourceLocation memberLocation = this.currentLocation();
            String memberName = ParserUtils.parseIdentifier(this);
            MemberShape.Builder memberBuilder = ((MemberShape.Builder)((MemberShape.Builder)MemberShape.builder().id(id.withMember(memberName))).source(memberLocation)).target(UnitTypeTrait.UNIT);
            operation.addMember(memberBuilder);
            this.addTraits(memberBuilder.getId(), memberTraits);
            this.sp();
            if (this.peek() == '=') {
                this.expect('=');
                this.sp();
                Node value = IdlNodeParser.parseNode(this);
                memberBuilder.addTrait(new EnumValueTrait.Provider().createTrait(memberBuilder.getId(), value));
                this.clearPendingDocs();
                this.br();
                continue;
            }
            this.ws();
        }
        this.expect('}');
        this.clearPendingDocs();
        this.operations.accept(operation);
    }

    private void parseCollection(ShapeId id, SourceLocation location, CollectionShape.Builder<?, ?> builder) {
        LoadOperation.DefineShape operation = this.createShape((AbstractShapeBuilder<?, ?>)builder.id(id).source(location));
        this.parseMixins(operation);
        this.ws();
        this.expect('{');
        this.clearPendingDocs();
        this.ws();
        this.parsePossiblyElidedMember(operation, "member");
        this.ws();
        this.expect('}');
        this.clearPendingDocs();
        this.operations.accept(operation);
    }

    private void parsePossiblyElidedMember(LoadOperation.DefineShape operation, String memberName) {
        boolean isElided = false;
        List<TraitEntry> memberTraits = this.parseDocsAndTraits();
        if (this.peek() == '$') {
            isElided = true;
            if (!this.modelVersion.supportsTargetElision()) {
                throw this.syntax(operation.toShapeId().withMember(memberName), "Members can only elide targets in IDL version 2 or later");
            }
            this.expect('$');
        } else if (this.peek() != memberName.charAt(0)) {
            if (!memberTraits.isEmpty()) {
                throw this.syntax("Expected member definition to follow traits");
            }
            return;
        }
        MemberShape.Builder memberBuilder = (MemberShape.Builder)((MemberShape.Builder)MemberShape.builder().id(operation.toShapeId().withMember(memberName))).source(this.currentLocation());
        for (int i = 0; i < memberName.length(); ++i) {
            this.expect(memberName.charAt(i));
        }
        if (!isElided) {
            this.sp();
            this.expect(':');
            this.sp();
            this.addForwardReference(ParserUtils.parseShapeId(this), memberBuilder::target);
        }
        operation.addMember(memberBuilder);
        this.addTraits(memberBuilder.getId(), memberTraits);
        this.clearPendingDocs();
    }

    private void parseMapStatement(ShapeId id, SourceLocation location) {
        LoadOperation.DefineShape operation = this.createShape((AbstractShapeBuilder<?, ?>)MapShape.builder().id(id).source(location));
        this.parseMixins(operation);
        this.ws();
        this.expect('{');
        this.clearPendingDocs();
        this.ws();
        this.parsePossiblyElidedMember(operation, "key");
        this.ws();
        this.parsePossiblyElidedMember(operation, "value");
        this.ws();
        this.expect('}');
        this.clearPendingDocs();
        this.operations.accept(operation);
    }

    private void parseStructuredShape(ShapeId id, SourceLocation location, AbstractShapeBuilder<?, ?> builder, MemberParsing memberParsing) {
        LoadOperation.DefineShape operation = this.createShape((AbstractShapeBuilder<?, ?>)((AbstractShapeBuilder)builder.id(id)).source(location));
        if (builder.getShapeType() == ShapeType.STRUCTURE) {
            this.parseForResource(operation);
        }
        this.parseMixins(operation);
        this.parseMembers(operation, memberParsing);
        this.clearPendingDocs();
        this.operations.accept(operation);
    }

    private void parseMixins(LoadOperation.DefineShape operation) {
        this.sp();
        if (this.peek() != 'w') {
            return;
        }
        this.expect('w');
        this.expect('i');
        this.expect('t');
        this.expect('h');
        if (!this.modelVersion.supportsMixins()) {
            throw this.syntax(operation.toShapeId(), "Mixins can only be used with Smithy version 2 or later. Attempted to use mixins with version `" + (Object)((Object)this.modelVersion) + "`.");
        }
        this.ws();
        this.expect('[');
        this.ws();
        do {
            String target = ParserUtils.parseShapeId(this);
            this.addForwardReference(target, (ShapeId resolved) -> {
                operation.addDependency((ShapeId)resolved);
                operation.addModifier(new ApplyMixin((ShapeId)resolved));
            });
            this.ws();
        } while (this.peek() != ']');
        this.expect(']');
        this.clearPendingDocs();
    }

    private void parseMembers(LoadOperation.DefineShape op, MemberParsing memberParsing) {
        HashSet<String> definedMembers = new HashSet<String>();
        this.ws();
        this.expect('{');
        this.ws();
        while (!this.eof() && this.peek() != '}') {
            this.parseMember(op, definedMembers, memberParsing);
            this.clearPendingDocs();
            this.ws();
        }
        this.expect('}');
    }

    private void parseMember(LoadOperation.DefineShape operation, Set<String> defined, MemberParsing memberParsing) {
        String memberName;
        boolean isTargetElided;
        ShapeId parent = operation.toShapeId();
        List<TraitEntry> memberTraits = this.parseDocsAndTraits();
        SourceLocation memberLocation = this.currentLocation();
        boolean bl = isTargetElided = this.peek() == '$';
        if (isTargetElided) {
            this.expect('$');
        }
        if (defined.contains(memberName = ParserUtils.parseIdentifier(this))) {
            throw this.syntax(parent, "Duplicate member of " + parent + ": '" + memberName + '\'');
        }
        defined.add(memberName);
        ShapeId memberId = parent.withMember(memberName);
        if (isTargetElided && !this.modelVersion.supportsTargetElision()) {
            throw this.syntax(memberId, "Members can only elide targets in IDL version 2 or later");
        }
        MemberShape.Builder memberBuilder = (MemberShape.Builder)((MemberShape.Builder)MemberShape.builder().id(memberId)).source(memberLocation);
        if (!isTargetElided) {
            this.sp();
            this.expect(':');
            this.sp();
            this.addForwardReference(ParserUtils.parseShapeId(this), memberBuilder::target);
        }
        this.sp();
        if (memberParsing.supportsAssignment() && this.peek() == '=') {
            if (!this.modelVersion.isDefaultSupported()) {
                throw this.syntax("@default assignment is only supported in IDL version 2 or later");
            }
            this.expect('=');
            this.sp();
            memberBuilder.addTrait(memberParsing.createAssignmentTrait(memberId, IdlNodeParser.parseNode(this)));
            this.br();
        }
        operation.addMember(memberBuilder);
        this.addTraits(memberBuilder.getId(), memberTraits);
    }

    private void parseOperationStatement(ShapeId id, SourceLocation location) {
        OperationShape.Builder builder = (OperationShape.Builder)((OperationShape.Builder)OperationShape.builder().id(id)).source(location);
        LoadOperation.DefineShape operation = this.createShape(builder);
        this.parseMixins(operation);
        this.ws();
        this.expect('{');
        this.ws();
        this.parseProperties(id, propertyName -> {
            switch (propertyName) {
                case "input": {
                    TraitEntry inputTrait = new TraitEntry(InputTrait.ID.toString(), Node.objectNode(), true);
                    this.parseInlineableOperationMember(id, this.operationInputSuffix, builder::input, inputTrait);
                    break;
                }
                case "output": {
                    TraitEntry outputTrait = new TraitEntry(OutputTrait.ID.toString(), Node.objectNode(), true);
                    this.parseInlineableOperationMember(id, this.operationOutputSuffix, builder::output, outputTrait);
                    break;
                }
                case "errors": {
                    this.parseIdList(builder::addError);
                    break;
                }
                default: {
                    throw this.syntax(id, String.format("Unknown property %s for %s", propertyName, id));
                }
            }
            this.rws();
        });
        this.expect('}');
        this.clearPendingDocs();
        this.operations.accept(operation);
    }

    private void parseProperties(ShapeId id, Consumer<String> valueParser) {
        HashSet<String> defined = new HashSet<String>();
        while (!this.eof() && this.peek() != '}') {
            String key = ParserUtils.parseIdentifier(this);
            if (defined.contains(key)) {
                throw this.syntax(id, String.format("Duplicate operation %s property for %s", key, id));
            }
            defined.add(key);
            this.ws();
            this.expect(':');
            valueParser.accept(key);
            this.ws();
        }
    }

    private void parseInlineableOperationMember(ShapeId id, String suffix, Consumer<ShapeId> consumer, TraitEntry defaultTrait) {
        if (this.peek() == '=') {
            if (!this.modelVersion.supportsInlineOperationIO()) {
                throw this.syntax(id, "Inlined operation inputs and outputs can only be used with Smithy version 2 or later. Attempted to use inlined IO with version `" + (Object)((Object)this.modelVersion) + "`.");
            }
            this.expect('=');
            this.clearPendingDocs();
            this.ws();
            consumer.accept(this.parseInlineStructure(id.getName() + suffix, defaultTrait));
        } else {
            this.ws();
            this.addForwardReference(ParserUtils.parseShapeId(this), consumer);
        }
    }

    private ShapeId parseInlineStructure(String name, TraitEntry defaultTrait) {
        List<TraitEntry> traits = this.parseDocsAndTraits();
        if (defaultTrait != null) {
            traits.add(defaultTrait);
        }
        ShapeId id = ShapeId.fromRelative(this.expectNamespace(), name);
        SourceLocation location = this.currentLocation();
        StructureShape.Builder builder = (StructureShape.Builder)((StructureShape.Builder)StructureShape.builder().id(id)).source(location);
        LoadOperation.DefineShape operation = this.createShape(builder);
        this.parseMixins(operation);
        this.parseForResource(operation);
        this.parseMembers(operation, MemberParsing.PARSING_STRUCTURE_MEMBER);
        this.addTraits(id, traits);
        this.clearPendingDocs();
        this.operations.accept(operation);
        return id;
    }

    private void parseForResource(LoadOperation.DefineShape operation) {
        this.sp();
        if (this.peek() != 'f') {
            return;
        }
        this.expect('f');
        this.expect('o');
        this.expect('r');
        if (!this.modelVersion.supportsTargetElision()) {
            throw this.syntax(operation.toShapeId(), "Structures can only be bound to resources with Smithy version 2 or later. Attempted to bind a structure to a resource with version `" + (Object)((Object)this.modelVersion) + "`.");
        }
        this.rsp();
        this.addForwardReference(ParserUtils.parseShapeId(this), (ShapeId shapeId) -> {
            operation.addDependency((ShapeId)shapeId);
            operation.addModifier(new ApplyResourceBasedTargets((ShapeId)shapeId));
        });
    }

    private void parseIdList(Consumer<ShapeId> consumer) {
        this.increaseNestingLevel();
        this.ws();
        this.expect('[');
        this.ws();
        while (!this.eof() && this.peek() != ']') {
            this.addForwardReference(ParserUtils.parseShapeId(this), consumer);
            this.ws();
        }
        this.expect(']');
        this.decreaseNestingLevel();
    }

    private void parseServiceStatement(ShapeId id, SourceLocation location) {
        ServiceShape.Builder builder = (ServiceShape.Builder)((ServiceShape.Builder)new ServiceShape.Builder().id(id)).source(location);
        LoadOperation.DefineShape operation = this.createShape(builder);
        this.parseMixins(operation);
        this.ws();
        ObjectNode shapeNode = IdlNodeParser.parseObjectNode(this, id.toString());
        LoaderUtils.checkForAdditionalProperties(shapeNode, id, SERVICE_PROPERTY_NAMES).ifPresent(this::emit);
        shapeNode.getStringMember(VERSION_KEY).map(StringNode::getValue).ifPresent(builder::version);
        this.optionalIdList(shapeNode, OPERATIONS_KEY, builder::addOperation);
        this.optionalIdList(shapeNode, RESOURCES_KEY, builder::addResource);
        this.optionalIdList(shapeNode, ERRORS_KEY, builder::addError);
        AstModelLoader.loadServiceRenameIntoBuilder(builder, shapeNode);
        this.clearPendingDocs();
        this.operations.accept(operation);
    }

    private void optionalId(ObjectNode node, String name, Consumer<ShapeId> consumer) {
        if (node.getMember(name).isPresent()) {
            this.addForwardReference(node.expectStringMember(name).getValue(), consumer);
        }
    }

    private void optionalIdList(ObjectNode node, String name, Consumer<ShapeId> consumer) {
        if (node.getMember(name).isPresent()) {
            ArrayNode value = node.expectArrayMember(name);
            for (StringNode element : value.getElementsAs(StringNode.class)) {
                this.addForwardReference(element.getValue(), consumer);
            }
        }
    }

    private void parseResourceStatement(ShapeId id, SourceLocation location) {
        ResourceShape.Builder builder = (ResourceShape.Builder)((ResourceShape.Builder)ResourceShape.builder().id(id)).source(location);
        LoadOperation.DefineShape operation = this.createShape(builder);
        this.parseMixins(operation);
        this.ws();
        ObjectNode shapeNode = IdlNodeParser.parseObjectNode(this, id.toString());
        LoaderUtils.checkForAdditionalProperties(shapeNode, id, RESOURCE_PROPERTY_NAMES).ifPresent(this::emit);
        this.optionalId(shapeNode, PUT_KEY, builder::put);
        this.optionalId(shapeNode, CREATE_KEY, builder::create);
        this.optionalId(shapeNode, READ_KEY, builder::read);
        this.optionalId(shapeNode, UPDATE_KEY, builder::update);
        this.optionalId(shapeNode, DELETE_KEY, builder::delete);
        this.optionalId(shapeNode, LIST_KEY, builder::list);
        this.optionalIdList(shapeNode, OPERATIONS_KEY, builder::addOperation);
        this.optionalIdList(shapeNode, RESOURCES_KEY, builder::addResource);
        this.optionalIdList(shapeNode, COLLECTION_OPERATIONS_KEY, builder::addCollectionOperation);
        shapeNode.getObjectMember(IDENTIFIERS_KEY).ifPresent(ids -> {
            for (Map.Entry<StringNode, Node> entry : ids.getMembers().entrySet()) {
                String name = entry.getKey().getValue();
                StringNode target = entry.getValue().expectStringNode();
                this.addForwardReference(target.getValue(), (ShapeId targetId) -> builder.addIdentifier(name, (ToShapeId)targetId));
            }
        });
        shapeNode.getObjectMember(PROPERTIES_KEY).ifPresent(properties -> {
            if (!this.modelVersion.supportsResourceProperties()) {
                throw this.syntax(id, "Resource properties can only be used with Smithy version 2 or later. Attempted to use resource properties with version `" + (Object)((Object)this.modelVersion) + "`.");
            }
            for (Map.Entry<StringNode, Node> entry : properties.getMembers().entrySet()) {
                String name = entry.getKey().getValue();
                StringNode target = entry.getValue().expectStringNode();
                this.addForwardReference(target.getValue(), (ShapeId targetId) -> builder.addProperty(name, (ToShapeId)targetId));
            }
        });
        this.clearPendingDocs();
        this.operations.accept(operation);
    }

    private void parseComment() {
        this.expect('/');
        this.consumeRemainingCharactersOnLine();
    }

    private void parseDocComment() {
        SourceLocation location = this.currentLocation();
        StringJoiner joiner = new StringJoiner("\n");
        do {
            joiner.add(this.parseDocCommentLine());
        } while (this.peekDocComment());
        this.pendingDocumentationComment = new TraitEntry(DocumentationTrait.ID.toString(), new StringNode(joiner.toString(), location), false);
    }

    private boolean peekDocComment() {
        return this.peek() == '/' && this.peek(1) == '/' && this.peek(2) == '/';
    }

    private String parseDocCommentLine() {
        this.expect('/');
        this.expect('/');
        this.expect('/');
        if (this.peek() == ' ') {
            this.skip();
        }
        int start = this.position();
        this.consumeRemainingCharactersOnLine();
        this.nl();
        this.sp();
        return StringUtils.stripEnd((String)this.sliceFrom(start), (String)" \t\r\n");
    }

    private void nl() {
        switch (this.peek()) {
            case '\n': {
                this.skip();
                break;
            }
            case '\r': {
                this.skip();
                if (this.peek() != '\n') break;
                this.expect('\n');
                break;
            }
            default: {
                throw this.syntax("Expected a newline");
            }
        }
    }

    private void parseApplyStatement() {
        List<TraitEntry> traitsToApply;
        this.expect('a');
        this.expect('p');
        this.expect('p');
        this.expect('l');
        this.expect('y');
        this.rsp();
        String name = ParserUtils.parseShapeId(this);
        this.rws();
        if (this.peek() == '{') {
            this.expect('{');
            this.ws();
            traitsToApply = IdlTraitParser.parseTraits(this);
            this.expect('}');
        } else {
            traitsToApply = Collections.singletonList(IdlTraitParser.parseTraitValue(this));
        }
        this.addForwardReference(name, (ShapeId target) -> {
            for (TraitEntry traitEntry : traitsToApply) {
                this.onDeferredTrait((ShapeId)target, traitEntry.traitName, traitEntry.value, traitEntry.isAnnotation);
            }
        });
        this.clearPendingDocs();
        this.br();
    }

    private void addTraits(ShapeId id, List<TraitEntry> traits) {
        for (TraitEntry traitEntry : traits) {
            this.onDeferredTrait(id, traitEntry.traitName, traitEntry.value, traitEntry.isAnnotation);
        }
    }

    private void onDeferredTrait(ShapeId target, String traitName, Node traitValue, boolean isAnnotation) {
        this.addForwardReference(traitName, (ShapeId traitId, Function<ShapeId, ShapeType> typeProvider) -> {
            Node coerced = this.coerceTraitValue(traitValue, isAnnotation, (ShapeType)((Object)((Object)typeProvider.apply(traitId))));
            this.operations.accept(new LoadOperation.ApplyTrait(this.modelVersion, traitValue.getSourceLocation(), this.expectNamespace(), target, (ShapeId)traitId, coerced));
        });
    }

    private Node coerceTraitValue(Node value, boolean isAnnotation, ShapeType targetType) {
        if (isAnnotation && value.isNullNode()) {
            if (targetType == null || targetType == ShapeType.STRUCTURE || targetType == ShapeType.MAP) {
                return new ObjectNode(Collections.emptyMap(), value.getSourceLocation());
            }
            if (targetType == ShapeType.LIST || targetType == ShapeType.SET) {
                return new ArrayNode(Collections.emptyList(), value.getSourceLocation());
            }
        }
        return value;
    }

    SourceLocation currentLocation() {
        return new SourceLocation(this.filename, this.line(), this.column());
    }

    NumberNode parseNumberNode(SourceLocation location) {
        String lexeme = ParserUtils.parseNumber(this);
        if (lexeme.contains("e") || lexeme.contains("E") || lexeme.contains(".")) {
            double value = Double.parseDouble(lexeme);
            if (Double.isFinite(value)) {
                return new NumberNode(value, location);
            }
            return new NumberNode(new BigDecimal(lexeme), location);
        }
        try {
            return new NumberNode(Long.parseLong(lexeme), location);
        }
        catch (NumberFormatException e) {
            return new NumberNode(new BigInteger(lexeme), location);
        }
    }

    private String peekDebugMessage() {
        StringBuilder result = new StringBuilder(this.expression().length());
        char c = this.peek();
        if (c == ' ' || ParserUtils.isIdentifierStart(c) || ParserUtils.isDigit(c)) {
            int i;
            if (c == ' ') {
                result.append(' ');
            }
            int n = i = c == ' ' ? 1 : 0;
            while (i < 16 && (ParserUtils.isIdentifierStart(c = this.peek(i)) || ParserUtils.isDigit(c))) {
                result.append(c);
                ++i;
            }
        } else {
            for (int i = 0; i < 2; ++i) {
                char peek = this.peek(i);
                if (peek == '\u0000') continue;
                result.append(peek);
            }
        }
        return result.length() == 0 ? "[EOF]" : result.toString();
    }

    static {
        for (ShapeType type : ShapeType.values()) {
            if (type == ShapeType.MEMBER) continue;
            SHAPE_TYPES.add(type.toString());
        }
    }

    private static enum MemberParsing {
        PARSING_STRUCTURE_MEMBER{

            @Override
            boolean supportsAssignment() {
                return true;
            }

            @Override
            Trait createAssignmentTrait(ShapeId id, Node value) {
                return new DefaultTrait(value);
            }
        }
        ,
        PARSING_MEMBER{

            @Override
            boolean supportsAssignment() {
                return false;
            }

            @Override
            Trait createAssignmentTrait(ShapeId id, Node value) {
                throw new UnsupportedOperationException();
            }
        };


        abstract boolean supportsAssignment();

        abstract Trait createAssignmentTrait(ShapeId var1, Node var2);
    }

    static final class TraitEntry {
        final String traitName;
        final Node value;
        final boolean isAnnotation;

        TraitEntry(String traitName, Node value, boolean isAnnotation) {
            this.traitName = traitName;
            this.value = value;
            this.isAnnotation = isAnnotation;
        }
    }
}

