/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import software.amazon.smithy.model.loader.ModelSyntaxException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.traits.BoxTrait;
import software.amazon.smithy.model.traits.DefaultTrait;
import software.amazon.smithy.model.traits.MixinTrait;

enum Version {
    UNKNOWN{

        public String toString() {
            return "";
        }

        @Override
        boolean supportsMixins() {
            return true;
        }

        @Override
        boolean supportsInlineOperationIO() {
            return true;
        }

        @Override
        boolean supportsTargetElision() {
            return true;
        }

        @Override
        boolean isDefaultSupported() {
            return true;
        }

        @Override
        boolean isShapeTypeSupported(ShapeType shapeType) {
            return true;
        }

        @Override
        boolean isDeprecated() {
            return false;
        }

        @Override
        void validateVersionedTrait(ShapeId target, ShapeId traitId, Node value) {
        }
    }
    ,
    VERSION_1_0{

        public String toString() {
            return "1.0";
        }

        @Override
        boolean supportsMixins() {
            return false;
        }

        @Override
        boolean supportsInlineOperationIO() {
            return false;
        }

        @Override
        boolean supportsTargetElision() {
            return false;
        }

        @Override
        boolean isDefaultSupported() {
            return false;
        }

        @Override
        boolean isShapeTypeSupported(ShapeType shapeType) {
            return shapeType != ShapeType.ENUM && shapeType != ShapeType.INT_ENUM;
        }

        @Override
        void validateVersionedTrait(ShapeId target, ShapeId traitId, Node value) {
            String errorMessage = null;
            if (traitId.equals(MixinTrait.ID)) {
                errorMessage = String.format("Mixins can only be used in Smithy 2.0 or later. Attempted to apply a @mixin trait to `%s` in a model file using version `%s`.", new Object[]{target, this});
            } else if (traitId.equals(DefaultTrait.ID)) {
                errorMessage = "The @default trait can only be used in Smithy 2.0 or later";
            }
            if (errorMessage != null) {
                throw ModelSyntaxException.builder().message(errorMessage).shapeId(target).sourceLocation(value).build();
            }
        }

        @Override
        boolean isDeprecated() {
            return true;
        }
    }
    ,
    VERSION_2_0{

        public String toString() {
            return "2.0";
        }

        @Override
        boolean supportsMixins() {
            return true;
        }

        @Override
        boolean supportsInlineOperationIO() {
            return true;
        }

        @Override
        boolean supportsTargetElision() {
            return true;
        }

        @Override
        boolean isDefaultSupported() {
            return true;
        }

        @Override
        boolean isShapeTypeSupported(ShapeType shapeType) {
            return shapeType != ShapeType.SET;
        }

        @Override
        boolean isDeprecated() {
            return false;
        }

        @Override
        void validateVersionedTrait(ShapeId target, ShapeId traitId, Node value) {
            if (traitId.equals(BoxTrait.ID)) {
                throw ModelSyntaxException.builder().message("@box is not supported in Smithy IDL 2.0").shapeId(target).sourceLocation(value).build();
            }
        }
    };


    static Version fromString(String value) {
        switch (value) {
            case "1.0": 
            case "1": {
                return VERSION_1_0;
            }
            case "2": 
            case "2.0": {
                return VERSION_2_0;
            }
        }
        return null;
    }

    boolean supportsResourceProperties() {
        return this == VERSION_2_0;
    }

    abstract boolean isDeprecated();

    abstract boolean supportsMixins();

    abstract boolean supportsInlineOperationIO();

    abstract boolean supportsTargetElision();

    abstract boolean isDefaultSupported();

    abstract boolean isShapeTypeSupported(ShapeType var1);

    abstract void validateVersionedTrait(ShapeId var1, ShapeId var2, Node var3);
}

