/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.Optional;
import software.amazon.smithy.model.node.ExpectationNotMetException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NumberNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class EnumValueTrait
extends AbstractTrait
implements ToSmithyBuilder<EnumValueTrait> {
    public static final ShapeId ID = ShapeId.from("smithy.api#enumValue");
    private final Node value;

    private EnumValueTrait(Builder builder) {
        super(ID, builder.sourceLocation);
        if (builder.value == null) {
            throw new IllegalStateException("No integer or string value set on EnumValueTrait");
        }
        this.value = builder.value;
    }

    public Optional<String> getStringValue() {
        return this.value.asStringNode().map(StringNode::getValue);
    }

    public String expectStringValue() {
        return this.getStringValue().orElseThrow(() -> new ExpectationNotMetException("Expected string value was not set.", this));
    }

    public Optional<Integer> getIntValue() {
        return this.value.asNumberNode().map(NumberNode::getValue).map(Number::intValue);
    }

    public int expectIntValue() {
        return this.getIntValue().orElseThrow(() -> new ExpectationNotMetException("Expected integer value was not set.", this));
    }

    @Override
    protected Node createNode() {
        return this.value;
    }

    public SmithyBuilder<EnumValueTrait> toBuilder() {
        Builder builder = (Builder)EnumValueTrait.builder().sourceLocation(this.getSourceLocation());
        builder.value = this.value;
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractTraitBuilder<EnumValueTrait, Builder> {
        private Node value;

        public EnumValueTrait build() {
            return new EnumValueTrait(this);
        }

        public Builder stringValue(String string) {
            this.value = Node.from(string);
            return this;
        }

        public Builder intValue(int integer) {
            this.value = Node.from(integer);
            return this;
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        @Override
        public Trait createTrait(ShapeId target, Node value) {
            Builder builder = (Builder)EnumValueTrait.builder().sourceLocation(value);
            builder.value = value;
            return builder.build();
        }
    }
}

