/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.traits.DefaultTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.NodeValidationVisitor;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class DefaultTraitValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        NodeValidationVisitor visitor = null;
        for (MemberShape shape : model.getMemberShapesWithTrait(DefaultTrait.class)) {
            DefaultTrait trait = shape.expectTrait(DefaultTrait.class);
            Node value = trait.toNode();
            if (visitor == null) {
                visitor = NodeValidationVisitor.builder().model(model).eventId(this.getName()).value(value).startingContext("Error validating @default trait").eventShapeId(shape.getId()).build();
            } else {
                visitor.setValue(value);
                visitor.setEventShapeId(shape.getId());
            }
            events.addAll((Collection<ValidationEvent>)shape.accept(visitor));
            switch (model.expectShape(shape.getTarget()).getType()) {
                case MAP: {
                    value.asObjectNode().ifPresent(obj -> {
                        if (!obj.isEmpty()) {
                            events.add(this.error(shape, trait, "The @default value of a map must be an empty map"));
                        }
                    });
                    break;
                }
                case LIST: 
                case SET: {
                    value.asArrayNode().ifPresent(array -> {
                        if (!array.isEmpty()) {
                            events.add(this.error(shape, trait, "The @default value of a list must be an empty list"));
                        }
                    });
                    break;
                }
                case DOCUMENT: {
                    value.asArrayNode().ifPresent(array -> {
                        if (!array.isEmpty()) {
                            events.add(this.error(shape, trait, "The @default value of a document cannot be a non-empty array"));
                        }
                    });
                    value.asObjectNode().ifPresent(obj -> {
                        if (!obj.isEmpty()) {
                            events.add(this.error(shape, trait, "The @default value of a document cannot be a non-empty object"));
                        }
                    });
                    break;
                }
            }
        }
        return events;
    }
}

