/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NeighborProviderIndex;
import software.amazon.smithy.model.knowledge.ServiceIndex;
import software.amazon.smithy.model.neighbor.NeighborProvider;
import software.amazon.smithy.model.neighbor.Relationship;
import software.amazon.smithy.model.neighbor.RelationshipDirection;
import software.amazon.smithy.model.neighbor.Walker;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.HttpPayloadTrait;
import software.amazon.smithy.model.traits.ProtocolDefinitionTrait;
import software.amazon.smithy.model.traits.RequiresLengthTrait;
import software.amazon.smithy.model.traits.StreamingTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.Pair;

public final class StreamingTraitValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        if (!model.isTraitApplied(StreamingTrait.class)) {
            return Collections.emptyList();
        }
        List<ValidationEvent> events = this.validateStreamingTargets(model);
        events.addAll(this.validateAllEventStreamMembers(model));
        events.addAll(this.validateBlobTargetsArePayloads(model));
        return events;
    }

    private List<ValidationEvent> validateBlobTargetsArePayloads(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        ServiceIndex serviceIndex = ServiceIndex.of(model);
        Walker walker = new Walker(model);
        Set servicesWithPayloadSupportingProtocols = model.getServiceShapes().stream().filter(service -> serviceIndex.getProtocols((ToShapeId)service).values().stream().map(trait -> model.expectShape(trait.toShapeId())).map(traitShape -> traitShape.expectTrait(ProtocolDefinitionTrait.class)).anyMatch(protocol -> protocol.getTraits().contains(HttpPayloadTrait.ID))).collect(Collectors.toSet());
        for (ServiceShape service2 : servicesWithPayloadSupportingProtocols) {
            walker.walkShapes(service2).stream().filter(Shape::isMemberShape).map(shape -> shape.asMemberShape().get()).filter(memberShape -> !memberShape.hasTrait(HttpPayloadTrait.ID)).filter(memberShape -> model.expectShape(memberShape.getTarget()).isBlobShape()).filter(memberShape -> model.expectShape(memberShape.getTarget()).hasTrait(StreamingTrait.ID)).forEach(memberShape -> events.add(this.error((Shape)memberShape, String.format("Member `%s` referencing @streaming shape `%s` must have the @httpPayload trait, as service `%s` has a protocol that supports @httpPayload.", memberShape.toShapeId(), memberShape.getTarget(), service2.toShapeId()))));
        }
        return events;
    }

    private List<ValidationEvent> validateStreamingTargets(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        NeighborProvider provider = NeighborProviderIndex.of(model).getReverseProvider();
        for (MemberShape member : model.getMemberShapes()) {
            Shape target = model.expectShape(member.getTarget());
            if (!target.hasTrait(StreamingTrait.class)) continue;
            Shape container = model.expectShape(member.getContainer());
            for (Relationship rel : provider.getNeighbors(container)) {
                this.validateStreamingTargetRel(container, target, rel, events);
            }
        }
        return events;
    }

    private void validateStreamingTargetRel(Shape container, Shape target, Relationship rel, List<ValidationEvent> events) {
        if (rel.getRelationshipType().getDirection() == RelationshipDirection.DIRECTED) {
            switch (rel.getRelationshipType()) {
                case INPUT: {
                    break;
                }
                case OUTPUT: {
                    if (!target.hasTrait(RequiresLengthTrait.class)) break;
                    events.add(this.error(rel.getShape(), String.format("Structures that contain a reference to a stream marked with the @requiresLength trait can only be used as operation inputs, but this structure is referenced from `%s` as %s", rel.getShape().getId(), rel.getRelationshipType().toString().toLowerCase(Locale.ENGLISH))));
                    break;
                }
                default: {
                    events.add(this.error(rel.getShape(), String.format("This shape has an invalid `%s` relationship to a structure, `%s`, that contains a stream", new Object[]{rel.getRelationshipType(), container.getId()})));
                }
            }
        }
    }

    private List<ValidationEvent> validateAllEventStreamMembers(Model model) {
        return model.shapes(UnionShape.class).filter(shape -> shape.hasTrait(StreamingTrait.class)).flatMap(shape -> this.validateUnionMembers(model, (UnionShape)shape).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateUnionMembers(Model model, UnionShape shape) {
        String invalidMembers = shape.getAllMembers().values().stream().map(em -> Pair.of((Object)em.getMemberName(), (Object)model.getShape(em.getTarget()).orElse(null))).filter(pair -> pair.getRight() != null && !(pair.getRight() instanceof StructureShape)).map(Pair::getLeft).sorted().collect(Collectors.joining(", "));
        if (!invalidMembers.isEmpty()) {
            return ListUtils.of((Object)this.error(shape, String.format("Each member of an event stream union must target a structure shape, but the following union members do not: [%s]", invalidMembers)));
        }
        return Collections.emptyList();
    }
}

