/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation;

import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.validation.LineValidationEventFormatter;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEventFormatter;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ValidationEvent
implements Comparable<ValidationEvent>,
ToNode,
ToSmithyBuilder<ValidationEvent> {
    private static final ValidationEventFormatter DEFAULT_FORMATTER = new LineValidationEventFormatter();
    private final SourceLocation sourceLocation;
    private final String message;
    private final String eventId;
    private final Severity severity;
    private final ShapeId shapeId;
    private final String suppressionReason;
    private int hash;

    private ValidationEvent(Builder builder) {
        if (builder.suppressionReason != null && builder.severity != Severity.SUPPRESSED) {
            throw new IllegalStateException("A suppression reason must only be provided for SUPPRESSED events");
        }
        this.sourceLocation = (SourceLocation)SmithyBuilder.requiredState((String)"sourceLocation", (Object)builder.sourceLocation);
        this.message = (String)SmithyBuilder.requiredState((String)"message", (Object)builder.message);
        this.severity = (Severity)SmithyBuilder.requiredState((String)"severity", (Object)builder.severity);
        this.eventId = (String)SmithyBuilder.requiredState((String)"id", (Object)builder.eventId);
        this.shapeId = builder.shapeId;
        this.suppressionReason = builder.suppressionReason;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ValidationEvent fromSourceException(SourceException exception) {
        return ValidationEvent.fromSourceException(exception, "");
    }

    public static ValidationEvent fromSourceException(SourceException exception, String prefix) {
        return ValidationEvent.builder().id("Model").severity(Severity.ERROR).message(prefix + exception.getMessageWithoutLocation()).sourceLocation(exception.getSourceLocation()).build();
    }

    @Override
    public int compareTo(ValidationEvent other) {
        int comparison = this.getSourceLocation().getFilename().compareTo(other.getSourceLocation().getFilename());
        if (comparison != 0) {
            return comparison;
        }
        comparison = Integer.compare(this.getSourceLocation().getLine(), other.getSourceLocation().getLine());
        if (comparison != 0) {
            return comparison;
        }
        comparison = Integer.compare(this.getSourceLocation().getColumn(), other.getSourceLocation().getColumn());
        if (comparison != 0) {
            return comparison;
        }
        return this.toString().compareTo(other.toString());
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.sourceLocation = this.sourceLocation;
        builder.message = this.message;
        builder.severity = this.severity;
        builder.eventId = this.eventId;
        builder.shapeId = this.shapeId;
        builder.suppressionReason = this.suppressionReason;
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValidationEvent)) {
            return false;
        }
        ValidationEvent other = (ValidationEvent)o;
        return this.sourceLocation.equals(other.sourceLocation) && this.message.equals(other.message) && this.severity.equals(other.severity) && this.eventId.equals(other.eventId) && this.getShapeId().equals(other.getShapeId()) && this.getSuppressionReason().equals(other.getSuppressionReason());
    }

    public int hashCode() {
        int result = this.hash;
        if (result == 0) {
            this.hash = result = Objects.hash(this.eventId, this.shapeId, this.severity, this.sourceLocation, this.message, this.suppressionReason);
        }
        return result;
    }

    public String toString() {
        return DEFAULT_FORMATTER.format(this);
    }

    @Override
    public Node toNode() {
        return Node.objectNodeBuilder().withMember("id", Node.from(this.getId())).withMember("severity", Node.from(this.getSeverity().toString())).withOptionalMember("shapeId", this.getShapeId().map(Object::toString).map(Node::from)).withMember("message", Node.from(this.getMessage())).withOptionalMember("suppressionReason", this.getSuppressionReason().map(Node::from)).withMember("filename", Node.from(this.getSourceLocation().getFilename())).withMember("line", Node.from(this.getSourceLocation().getLine())).withMember("column", Node.from(this.getSourceLocation().getColumn())).build();
    }

    public static ValidationEvent fromNode(Node node) {
        ObjectNode objectNode = node.expectObjectNode();
        SourceLocation location = new SourceLocation(objectNode.expectStringMember("filename").getValue(), objectNode.getNumberMemberOrDefault("line", 0).intValue(), objectNode.getNumberMemberOrDefault("column", 0).intValue());
        Builder builder = ValidationEvent.builder().id(objectNode.expectStringMember("id").getValue()).severity(Severity.valueOf(objectNode.expectStringMember("severity").getValue())).message(objectNode.expectStringMember("message").getValue()).sourceLocation(location);
        objectNode.getStringMember("suppressionReason").map(StringNode::getValue).ifPresent(builder::suppressionReason);
        objectNode.getStringMember("shapeId").map(StringNode::getValue).map(ShapeId::from).ifPresent(builder::shapeId);
        return builder.build();
    }

    public SourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    public String getMessage() {
        return this.message;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getEventId() {
        return this.getId();
    }

    public String getId() {
        return this.eventId;
    }

    public Optional<ShapeId> getShapeId() {
        return Optional.ofNullable(this.shapeId);
    }

    public Optional<String> getSuppressionReason() {
        return Optional.ofNullable(this.suppressionReason);
    }

    public static final class Builder
    implements SmithyBuilder<ValidationEvent> {
        private SourceLocation sourceLocation = SourceLocation.none();
        private String message;
        private Severity severity;
        private String eventId;
        private ShapeId shapeId;
        private String suppressionReason;

        private Builder() {
        }

        public Builder message(String eventMessage) {
            this.message = Objects.requireNonNull(eventMessage);
            return this;
        }

        public Builder message(String eventMessage, Object ... placeholders) {
            return this.message(String.format(eventMessage, placeholders));
        }

        public Builder severity(Severity severity) {
            this.severity = Objects.requireNonNull(severity);
            return this;
        }

        public Builder eventId(String eventId) {
            return this.id(eventId);
        }

        public Builder id(String eventId) {
            this.eventId = Objects.requireNonNull(eventId);
            return this;
        }

        public Builder sourceLocation(FromSourceLocation sourceLocation) {
            this.sourceLocation = Objects.requireNonNull(sourceLocation.getSourceLocation());
            return this;
        }

        public <T extends ToShapeId> Builder shapeId(T toShapeId) {
            this.shapeId = toShapeId == null ? null : toShapeId.toShapeId();
            return this;
        }

        public Builder shape(Shape encounteredShape) {
            return this.sourceLocation(Objects.requireNonNull(encounteredShape).getSourceLocation()).shapeId(encounteredShape.getId());
        }

        public Builder suppressionReason(String eventSuppressionReason) {
            this.suppressionReason = eventSuppressionReason;
            return this;
        }

        public ValidationEvent build() {
            return new ValidationEvent(this);
        }
    }
}

