/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.Optional;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class DeprecatedTrait
extends AbstractTrait
implements ToSmithyBuilder<DeprecatedTrait> {
    public static final ShapeId ID = ShapeId.from("smithy.api#deprecated");
    private final String since;
    private final String message;

    private DeprecatedTrait(Builder builder) {
        super(ID, builder.sourceLocation);
        this.since = builder.since;
        this.message = builder.message;
    }

    public Optional<String> getSince() {
        return Optional.ofNullable(this.since);
    }

    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    @Override
    protected Node createNode() {
        return new ObjectNode(MapUtils.of(), this.getSourceLocation()).withOptionalMember("since", this.getSince().map(Node::from)).withOptionalMember("message", this.getMessage().map(Node::from));
    }

    public Builder toBuilder() {
        return (Builder)DeprecatedTrait.builder().since(this.since).message(this.message).sourceLocation(this.getSourceLocation());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractTraitBuilder<DeprecatedTrait, Builder> {
        private String since;
        private String message;

        private Builder() {
        }

        public Builder since(String since) {
            this.since = since;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public DeprecatedTrait build() {
            return new DeprecatedTrait(this);
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        @Override
        public Trait createTrait(ShapeId target, Node value) {
            Builder builder = (Builder)DeprecatedTrait.builder().sourceLocation(value);
            ObjectNode objectNode = value.expectObjectNode();
            String sinceValue = objectNode.getMember("since").map(v -> v.expectStringNode().getValue()).orElse(null);
            String messageValue = objectNode.getMember("message").map(v -> v.expectStringNode().getValue()).orElse(null);
            builder.since(sinceValue).message(messageValue);
            DeprecatedTrait result = builder.build();
            result.setNodeCache(value);
            return result;
        }
    }
}

