/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.Collection;
import java.util.Set;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.utils.BuilderRef;

public abstract class EntityShape
extends Shape {
    private final Set<ShapeId> resources;
    private final Set<ShapeId> operations;

    EntityShape(Builder<?, ?> builder) {
        super(builder, false);
        this.resources = (Set)((Builder)builder).resources.copy();
        this.operations = (Set)((Builder)builder).operations.copy();
    }

    public final Set<ShapeId> getResources() {
        return this.resources;
    }

    public final Set<ShapeId> getOperations() {
        return this.operations;
    }

    public Set<ShapeId> getAllOperations() {
        return this.getOperations();
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        EntityShape o = (EntityShape)other;
        return this.getResources().equals(o.getResources()) && this.getAllOperations().equals(o.getAllOperations());
    }

    public static abstract class Builder<B extends Builder<?, ?>, S extends EntityShape>
    extends AbstractShapeBuilder<B, S> {
        private final BuilderRef<Set<ShapeId>> resources = BuilderRef.forOrderedSet();
        private final BuilderRef<Set<ShapeId>> operations = BuilderRef.forOrderedSet();

        public B operations(Collection<ShapeId> ids) {
            this.clearOperations();
            ((Set)this.operations.get()).addAll(ids);
            return (B)this;
        }

        public B addOperation(ToShapeId id) {
            ((Set)this.operations.get()).add(id.toShapeId());
            return (B)this;
        }

        public B addOperation(String id) {
            return this.addOperation(ShapeId.from(id));
        }

        public B removeOperation(ToShapeId id) {
            ((Set)this.operations.get()).remove(id.toShapeId());
            return (B)this;
        }

        public B clearOperations() {
            this.operations.clear();
            return (B)this;
        }

        public B resources(Collection<ShapeId> ids) {
            this.clearResources();
            ((Set)this.resources.get()).addAll(ids);
            return (B)this;
        }

        public B addResource(ToShapeId id) {
            ((Set)this.resources.get()).add(id.toShapeId());
            return (B)this;
        }

        public B addResource(String id) {
            return this.addResource(ShapeId.from(id));
        }

        public B removeResource(ToShapeId id) {
            ((Set)this.resources.get()).remove(id.toShapeId());
            return (B)this;
        }

        public B clearResources() {
            this.resources.clear();
            return (B)this;
        }
    }
}

