/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.ListUtils;

abstract class NamedMembersShape
extends Shape {
    private final Map<String, MemberShape> members;
    private volatile List<String> memberNames;

    NamedMembersShape(Builder<?, ?> builder) {
        super(builder, false);
        assert (((Builder)builder).members != null);
        this.members = (Map)((Builder)builder).members.copy();
        for (MemberShape member : this.members.values()) {
            if (member.getId().toString().startsWith(this.getId().toString())) continue;
            ShapeId expected = this.getId().withMember(member.getMemberName());
            throw new IllegalArgumentException(String.format("Expected the `%s` member of `%s` to have an ID of `%s` but found `%s`", member.getMemberName(), this.getId(), expected, member.getId()));
        }
    }

    public Map<String, MemberShape> getAllMembers() {
        return this.members;
    }

    public List<String> getMemberNames() {
        List names = this.memberNames;
        if (names == null) {
            this.memberNames = names = ListUtils.copyOf(this.members.keySet());
        }
        return names;
    }

    public Optional<MemberShape> getMember(String name) {
        return Optional.ofNullable(this.members.get(name));
    }

    @Override
    public Collection<MemberShape> members() {
        return this.members.values();
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        NamedMembersShape b = (NamedMembersShape)other;
        return this.getMemberNames().equals(b.getMemberNames()) && this.members.equals(b.members);
    }

    static abstract class Builder<B extends Builder<?, ?>, S extends NamedMembersShape>
    extends AbstractShapeBuilder<B, S> {
        private final BuilderRef<Map<String, MemberShape>> members = BuilderRef.forOrderedMap();

        Builder() {
        }

        @Override
        public final B id(ShapeId shapeId) {
            for (MemberShape member : ((Map)this.members.peek()).values()) {
                this.addMember(((MemberShape.Builder)member.toBuilder().id(shapeId.withMember(member.getMemberName()))).build());
            }
            return (B)((Builder)super.id(shapeId));
        }

        public B members(Collection<MemberShape> members) {
            this.members.clear();
            for (MemberShape member : members) {
                this.addMember(member);
            }
            return (B)this;
        }

        public B clearMembers() {
            this.members.clear();
            return (B)this;
        }

        @Override
        public B addMember(MemberShape member) {
            ((Map)this.members.get()).put(member.getMemberName(), member);
            return (B)this;
        }

        public B addMember(String memberName, ShapeId target) {
            return this.addMember(memberName, target, null);
        }

        public B addMember(String memberName, ShapeId target, Consumer<MemberShape.Builder> memberUpdater) {
            if (this.getId() == null) {
                throw new IllegalStateException("An id must be set before setting a member with a target");
            }
            MemberShape.Builder builder = (MemberShape.Builder)MemberShape.builder().target(target).id(this.getId().withMember(memberName));
            if (memberUpdater != null) {
                memberUpdater.accept(builder);
            }
            return (B)this.addMember(builder.build());
        }

        public B removeMember(String member) {
            if (this.members.hasValue()) {
                ((Map)this.members.get()).remove(member);
            }
            return (B)this;
        }
    }
}

