/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.EnumShape;
import software.amazon.smithy.model.shapes.IntEnumShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.EnumDefaultTrait;
import software.amazon.smithy.model.traits.EnumValueTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class EnumShapeValidator
extends AbstractValidator {
    private static final Pattern RECOMMENDED_NAME_PATTERN = Pattern.compile("^[A-Z]+[A-Z_0-9]*$");

    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (EnumShape enumShape : model.getEnumShapes()) {
            this.validateEnumShape(events, enumShape);
        }
        for (IntEnumShape intEnumShape : model.getIntEnumShapes()) {
            this.validateIntEnumShape(events, intEnumShape);
        }
        return events;
    }

    private void validateEnumShape(List<ValidationEvent> events, EnumShape shape) {
        HashSet<String> values = new HashSet<String>();
        for (MemberShape member : shape.members()) {
            if (member.hasTrait(EnumDefaultTrait.ID)) continue;
            Optional<String> value = member.expectTrait(EnumValueTrait.class).getStringValue();
            if (!value.isPresent()) {
                events.add(this.error(member, member.expectTrait(EnumValueTrait.class), "The enumValue trait must use the string option when applied to enum shapes."));
            } else {
                if (!values.add(value.get())) {
                    events.add(this.error(member, String.format("Multiple enum members found with duplicate value `%s`", value.get())));
                }
                if (value.get().equals("")) {
                    events.add(this.error(member, "enum values may not be empty because an empty string is the default value of enum shapes. Instead, use `smithy.api#enumDefault` to set an explicit name for the default value."));
                }
            }
            this.validateEnumMemberName(events, member);
        }
    }

    private void validateIntEnumShape(List<ValidationEvent> events, IntEnumShape shape) {
        HashSet<Integer> values = new HashSet<Integer>();
        for (MemberShape member : shape.members()) {
            if (member.hasTrait(EnumDefaultTrait.ID)) continue;
            if (!member.hasTrait(EnumValueTrait.ID)) {
                events.add(this.missingIntEnumValue(member, member));
            } else if (!member.expectTrait(EnumValueTrait.class).getIntValue().isPresent()) {
                events.add(this.missingIntEnumValue(member, member.expectTrait(EnumValueTrait.class)));
            } else {
                int value = member.expectTrait(EnumValueTrait.class).getIntValue().get();
                if (!values.add(value)) {
                    events.add(this.error(member, String.format("Multiple enum members found with duplicate value `%s`", value)));
                }
                if (value == 0) {
                    events.add(this.error(member, "intEnum values may not be set to 0 because 0 is the default value of intEnum shapes. Instead, use `smithy.api#enumDefault` to set an explicit name for the default value."));
                }
            }
            this.validateEnumMemberName(events, member);
        }
    }

    private ValidationEvent missingIntEnumValue(Shape shape, FromSourceLocation sourceLocation) {
        return this.error(shape, sourceLocation, "intEnum members must have the enumValue trait with the `int` member set");
    }

    private void validateEnumMemberName(List<ValidationEvent> events, MemberShape member) {
        if (!RECOMMENDED_NAME_PATTERN.matcher(member.getMemberName()).find()) {
            events.add(this.warning(member, String.format("The name `%s` does not match the recommended enum name format of beginning with an uppercase letter, followed by any number of uppercase letters, numbers, or underscores.", member.getMemberName())));
        }
    }
}

