/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.DeprecatedTrait;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class DeprecatedTraitValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (Shape trait : model.getShapesWithTrait(TraitDefinition.class)) {
            Set<Shape> shapesWithTrait;
            if (!trait.hasTrait(DeprecatedTrait.class) || (shapesWithTrait = model.getShapesWithTrait(trait)).isEmpty()) continue;
            DeprecatedTrait deprecatedTrait = trait.expectTrait(DeprecatedTrait.class);
            String traitMessage = trait.toShapeId().toString();
            if (deprecatedTrait.getMessage().isPresent()) {
                traitMessage = traitMessage + ", " + deprecatedTrait.getMessage().get();
            }
            for (Shape shape : shapesWithTrait) {
                events.add(this.warning(shape, trait, String.format("This shape applies a trait that is deprecated: %s", traitMessage)));
            }
        }
        return events;
    }
}

