/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.Optional;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.node.ExpectationNotMetException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NumberNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class EnumValueTrait
extends AbstractTrait
implements ToSmithyBuilder<EnumValueTrait> {
    public static final ShapeId ID = ShapeId.from("smithy.api#enumValue");
    private final String string;
    private final Integer integer;

    private EnumValueTrait(Builder builder) {
        super(ID, builder.sourceLocation);
        this.string = builder.string;
        this.integer = builder.integer;
        if (this.string == null && this.integer == null) {
            throw new SourceException("Either a string value or an integer value must be set for the enumValue trait.", this.getSourceLocation());
        }
    }

    public Optional<String> getStringValue() {
        return Optional.ofNullable(this.string);
    }

    public String expectStringValue() {
        return this.getStringValue().orElseThrow(() -> new ExpectationNotMetException("Expected string value was not set.", this));
    }

    public Optional<Integer> getIntValue() {
        return Optional.ofNullable(this.integer);
    }

    public int expectIntValue() {
        return this.getIntValue().orElseThrow(() -> new ExpectationNotMetException("Expected integer value was not set.", this));
    }

    @Override
    protected Node createNode() {
        if (this.getIntValue().isPresent()) {
            return new NumberNode(this.integer, this.getSourceLocation());
        }
        return new StringNode(this.string, this.getSourceLocation());
    }

    public SmithyBuilder<EnumValueTrait> toBuilder() {
        Builder builder = (Builder)EnumValueTrait.builder().sourceLocation(this.getSourceLocation());
        if (this.getIntValue().isPresent()) {
            builder.intValue(this.getIntValue().get());
        } else if (this.getStringValue().isPresent()) {
            builder.stringValue(this.getStringValue().get());
        }
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractTraitBuilder<EnumValueTrait, Builder> {
        private String string;
        private Integer integer;

        public EnumValueTrait build() {
            return new EnumValueTrait(this);
        }

        public Builder stringValue(String string) {
            this.string = string;
            this.integer = null;
            return this;
        }

        public Builder intValue(int integer) {
            this.integer = integer;
            this.string = null;
            return this;
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        @Override
        public Trait createTrait(ShapeId target, Node value) {
            Builder builder = (Builder)EnumValueTrait.builder().sourceLocation(value);
            value.asStringNode().ifPresent(node -> builder.stringValue(node.getValue()));
            value.asNumberNode().ifPresent(node -> {
                if (!node.isNaturalNumber()) {
                    throw new SourceException("Enum values may not use fractional numbers.", value.getSourceLocation());
                }
                builder.intValue(node.getValue().intValue());
            });
            EnumValueTrait result = builder.build();
            result.setNodeCache(value);
            return result;
        }
    }
}

