/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.CollectionShape;
import software.amazon.smithy.model.shapes.EnumShape;
import software.amazon.smithy.model.shapes.IntEnumShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.FunctionalUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.StringUtils;

public final class ModelSerializer {
    private final Predicate<String> metadataFilter;
    private final Predicate<Shape> shapeFilter;
    private final Predicate<Trait> traitFilter;

    private ModelSerializer(Builder builder) {
        this.metadataFilter = builder.metadataFilter;
        this.shapeFilter = !builder.includePrelude ? builder.shapeFilter.and(FunctionalUtils.not(Prelude::isPreludeShape)) : builder.shapeFilter;
        this.traitFilter = builder.traitFilter.and(FunctionalUtils.not(Trait::isSynthetic));
    }

    public ObjectNode serialize(Model model) {
        ShapeSerializer shapeSerializer = new ShapeSerializer();
        ObjectNode.Builder builder = Node.objectNodeBuilder().withMember("smithy", Node.from("2.0")).withOptionalMember("metadata", this.createMetadata(model).map(Node::withDeepSortedKeys));
        TreeMap<StringNode, Node> shapes = new TreeMap<StringNode, Node>();
        for (Shape shape : model.toSet()) {
            if (shape.isMemberShape() || !this.shapeFilter.test(shape)) continue;
            Node value = shape.accept(shapeSerializer);
            shapes.put(Node.from(shape.getId().toString()), value);
            if (shapeSerializer.mixinMemberTraits.isEmpty()) continue;
            for (MemberShape member : shapeSerializer.mixinMemberTraits) {
                ObjectNode.Builder applyBuilder = Node.objectNodeBuilder();
                applyBuilder.withMember("type", "apply");
                shapes.put(Node.from(member.getId().toString()), this.serializeTraits(applyBuilder, member.getIntroducedTraits().values()).build());
            }
        }
        builder.withMember("shapes", new ObjectNode(shapes, SourceLocation.NONE));
        return builder.build();
    }

    private Optional<Node> createMetadata(Model model) {
        Map<StringNode, Node> metadata = model.getMetadata().entrySet().stream().filter(entry -> this.metadataFilter.test((String)entry.getKey())).collect(Collectors.toMap(entry -> Node.from((String)entry.getKey()), Map.Entry::getValue));
        return metadata.isEmpty() ? Optional.empty() : Optional.of(new ObjectNode(metadata, SourceLocation.NONE));
    }

    public static Builder builder() {
        return new Builder();
    }

    private ObjectNode.Builder serializeTraits(ObjectNode.Builder builder, Collection<Trait> traits) {
        if (!traits.isEmpty()) {
            TreeMap<StringNode, Node> traitsToAdd = new TreeMap<StringNode, Node>();
            for (Trait trait : traits) {
                if (!this.traitFilter.test(trait)) continue;
                traitsToAdd.put(Node.from(trait.toShapeId().toString()), trait.toNode());
            }
            builder.withMember("traits", new ObjectNode(traitsToAdd, SourceLocation.none()));
        }
        return builder;
    }

    public static final class Builder
    implements SmithyBuilder<ModelSerializer> {
        private Predicate<String> metadataFilter = FunctionalUtils.alwaysTrue();
        private Predicate<Shape> shapeFilter = FunctionalUtils.alwaysTrue();
        private boolean includePrelude = false;
        private Predicate<Trait> traitFilter = FunctionalUtils.alwaysTrue();

        private Builder() {
        }

        public Builder metadataFilter(Predicate<String> metadataFilter) {
            this.metadataFilter = Objects.requireNonNull(metadataFilter);
            return this;
        }

        public Builder shapeFilter(Predicate<Shape> shapeFilter) {
            this.shapeFilter = Objects.requireNonNull(shapeFilter);
            return this;
        }

        public Builder includePrelude(boolean includePrelude) {
            this.includePrelude = includePrelude;
            return this;
        }

        public Builder traitFilter(Predicate<Trait> traitFilter) {
            this.traitFilter = traitFilter;
            return this;
        }

        public ModelSerializer build() {
            return new ModelSerializer(this);
        }
    }

    private final class ShapeSerializer
    extends ShapeVisitor.Default<Node> {
        private final Set<MemberShape> mixinMemberTraits = new TreeSet<MemberShape>();

        private ShapeSerializer() {
        }

        private ObjectNode.Builder createTypedBuilder(Shape shape) {
            ObjectNode.Builder builder = Node.objectNodeBuilder().withMember("type", Node.from(shape.getType().toString()));
            if (!shape.getMixins().isEmpty()) {
                ArrayList<ObjectNode> mixins = new ArrayList<ObjectNode>(shape.getMixins().size());
                for (ShapeId mixin : shape.getMixins()) {
                    mixins.add(this.serializeReference(mixin));
                }
                builder.withMember("mixins", Node.fromNodes(mixins));
            }
            return builder;
        }

        private ObjectNode.Builder serializeAllTraits(Shape shape, ObjectNode.Builder builder) {
            return ModelSerializer.this.serializeTraits(builder, shape.getIntroducedTraits().values());
        }

        @Override
        protected ObjectNode getDefault(Shape shape) {
            return this.serializeAllTraits(shape, this.createTypedBuilder(shape)).build();
        }

        @Override
        public Node enumShape(EnumShape shape) {
            return this.createNamedMemberShape(shape, shape.getAllMembers());
        }

        @Override
        public Node intEnumShape(IntEnumShape shape) {
            return this.createNamedMemberShape(shape, shape.getAllMembers());
        }

        @Override
        public Node listShape(ListShape shape) {
            return this.collectionShape(shape);
        }

        @Override
        public Node setShape(SetShape shape) {
            return this.collectionShape(shape);
        }

        public Node collectionShape(CollectionShape shape) {
            ObjectNode.Builder result = this.createTypedBuilder(shape);
            this.mixinMember(result, shape.getMember(), "member");
            return this.serializeAllTraits(shape, result).build();
        }

        private void mixinMember(ObjectNode.Builder builder, MemberShape member, String key) {
            if (member.getMixins().isEmpty()) {
                builder.withMember(key, member.accept(this));
            } else if (!member.getIntroducedTraits().isEmpty()) {
                this.mixinMemberTraits.add(member);
            }
        }

        @Override
        public Node mapShape(MapShape shape) {
            ObjectNode.Builder result = this.createTypedBuilder(shape);
            this.mixinMember(result, shape.getKey(), "key");
            this.mixinMember(result, shape.getValue(), "value");
            return this.serializeAllTraits(shape, result).build();
        }

        @Override
        public Node operationShape(OperationShape shape) {
            return this.serializeAllTraits(shape, this.createTypedBuilder(shape).withMember("input", this.serializeReference(shape.getInputShape())).withMember("output", this.serializeReference(shape.getOutputShape())).withOptionalMember("errors", this.createOptionalIdList(shape.getIntroducedErrors()))).build();
        }

        @Override
        public Node resourceShape(ResourceShape shape) {
            Optional<Object> identifiers = Optional.empty();
            if (shape.hasIdentifiers()) {
                Stream ids = shape.getIdentifiers().entrySet().stream();
                identifiers = Optional.of((Node)ids.collect(ObjectNode.collectStringKeys(Map.Entry::getKey, entry -> this.serializeReference((ShapeId)entry.getValue()))));
            }
            return this.serializeAllTraits(shape, this.createTypedBuilder(shape).withOptionalMember("identifiers", identifiers).withOptionalMember("put", shape.getPut().map(this::serializeReference)).withOptionalMember("create", shape.getCreate().map(this::serializeReference)).withOptionalMember("read", shape.getRead().map(this::serializeReference)).withOptionalMember("update", shape.getUpdate().map(this::serializeReference)).withOptionalMember("delete", shape.getDelete().map(this::serializeReference)).withOptionalMember("list", shape.getList().map(this::serializeReference)).withOptionalMember("operations", this.createOptionalIdList(shape.getIntroducedOperations())).withOptionalMember("collectionOperations", this.createOptionalIdList(shape.getCollectionOperations())).withOptionalMember("resources", this.createOptionalIdList(shape.getIntroducedResources()))).build();
        }

        @Override
        public Node serviceShape(ServiceShape shape) {
            ObjectNode.Builder serviceBuilder = this.createTypedBuilder(shape);
            if (!StringUtils.isBlank((CharSequence)shape.getIntroducedVersion())) {
                serviceBuilder.withMember("version", Node.from(shape.getIntroducedVersion()));
            }
            serviceBuilder.withOptionalMember("operations", this.createOptionalIdList(shape.getIntroducedOperations()));
            serviceBuilder.withOptionalMember("resources", this.createOptionalIdList(shape.getIntroducedResources()));
            serviceBuilder.withOptionalMember("errors", this.createOptionalIdList(shape.getIntroducedErrors()));
            if (!shape.getIntroducedRename().isEmpty()) {
                ObjectNode.Builder renameBuilder = Node.objectNodeBuilder();
                for (Map.Entry<ShapeId, String> entry : shape.getIntroducedRename().entrySet()) {
                    renameBuilder.withMember(entry.getKey().toString(), entry.getValue());
                }
                serviceBuilder.withMember("rename", renameBuilder.build());
            }
            return this.serializeAllTraits(shape, serviceBuilder).build();
        }

        private Optional<Node> createOptionalIdList(Collection<ShapeId> list) {
            if (list.isEmpty()) {
                return Optional.empty();
            }
            Node result = list.stream().sorted().map(this::serializeReference).collect(ArrayNode.collect());
            return Optional.of(result);
        }

        @Override
        public Node structureShape(StructureShape shape) {
            return this.createNamedMemberShape(shape, shape.getAllMembers());
        }

        @Override
        public Node unionShape(UnionShape shape) {
            return this.createNamedMemberShape(shape, shape.getAllMembers());
        }

        private ObjectNode createNamedMemberShape(Shape shape, Map<String, MemberShape> members) {
            ObjectNode.Builder result = this.createTypedBuilder(shape);
            ObjectNode.Builder membersBuilder = ObjectNode.objectNodeBuilder();
            for (MemberShape member : members.values()) {
                this.mixinMember(membersBuilder, member, member.getMemberName());
            }
            result.withMember("members", membersBuilder.build());
            return ModelSerializer.this.serializeTraits(result, shape.getIntroducedTraits().values()).build();
        }

        @Override
        public Node memberShape(MemberShape shape) {
            Collection<Trait> introducedTraits = shape.getIntroducedTraits().values();
            return ModelSerializer.this.serializeTraits(this.serializeReferenceBuilder(shape.getTarget()), introducedTraits).build();
        }

        private ObjectNode.Builder serializeReferenceBuilder(ShapeId id) {
            return Node.objectNodeBuilder().withMember("target", id.toString());
        }

        private ObjectNode serializeReference(ShapeId id) {
            return this.serializeReferenceBuilder(id).build();
        }
    }
}

