/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.loader.LoaderUtils;
import software.amazon.smithy.model.loader.Version;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.DynamicTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.TraitFactory;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;

public interface TraitContainer {
    public static final TraitContainer EMPTY = new TraitContainer(){

        @Override
        public Map<ShapeId, Map<ShapeId, Trait>> traits() {
            return Collections.emptyMap();
        }

        @Override
        public Map<ShapeId, Trait> getTraitsForShape(ShapeId shape) {
            return Collections.emptyMap();
        }

        @Override
        public void clearTraitsForShape(ShapeId shape) {
        }

        @Override
        public Map<ShapeId, Map<ShapeId, Trait>> getTraitsAppliedToPrelude() {
            return Collections.emptyMap();
        }

        @Override
        public void onTrait(ShapeId target, Trait value) {
            throw new UnsupportedOperationException("Cannot add trait " + value.toShapeId() + " to " + target);
        }

        @Override
        public void onTrait(ShapeId target, ShapeId traitId, Node value) {
            throw new UnsupportedOperationException("Cannot add trait " + traitId + " to " + target);
        }
    };

    public Map<ShapeId, Map<ShapeId, Trait>> traits();

    public Map<ShapeId, Trait> getTraitsForShape(ShapeId var1);

    public void clearTraitsForShape(ShapeId var1);

    public Map<ShapeId, Map<ShapeId, Trait>> getTraitsAppliedToPrelude();

    public void onTrait(ShapeId var1, Trait var2);

    public void onTrait(ShapeId var1, ShapeId var2, Node var3);

    public static final class VersionAwareTraitContainer
    implements TraitContainer {
        private final TraitContainer delegate;
        private Version version = Version.VERSION_1_0;

        VersionAwareTraitContainer(TraitContainer delegate) {
            this.delegate = delegate;
        }

        void setVersion(Version version) {
            this.version = version;
        }

        Version getVersion() {
            return this.version;
        }

        @Override
        public Map<ShapeId, Map<ShapeId, Trait>> traits() {
            return this.delegate.traits();
        }

        @Override
        public Map<ShapeId, Trait> getTraitsForShape(ShapeId shape) {
            return this.delegate.getTraitsForShape(shape);
        }

        @Override
        public void clearTraitsForShape(ShapeId shape) {
            this.delegate.clearTraitsForShape(shape);
        }

        @Override
        public Map<ShapeId, Map<ShapeId, Trait>> getTraitsAppliedToPrelude() {
            return this.delegate.getTraitsAppliedToPrelude();
        }

        @Override
        public void onTrait(ShapeId target, Trait value) {
            this.version.validateVersionedTrait(target, value.toShapeId(), value.toNode());
            this.delegate.onTrait(target, value);
        }

        @Override
        public void onTrait(ShapeId target, ShapeId traitId, Node value) {
            this.version.validateVersionedTrait(target, traitId, value);
            this.delegate.onTrait(target, traitId, value);
        }
    }

    public static final class TraitHashMap
    implements TraitContainer {
        private static final Logger LOGGER = Logger.getLogger(TraitContainer.class.getName());
        private final Map<ShapeId, Map<ShapeId, Trait>> targetToTraits = new HashMap<ShapeId, Map<ShapeId, Trait>>();
        private final Map<ShapeId, Map<ShapeId, Trait>> traitsAppliedToPrelude = new HashMap<ShapeId, Map<ShapeId, Trait>>();
        private final TraitFactory traitFactory;
        private final List<ValidationEvent> events;

        TraitHashMap(TraitFactory traitFactory, List<ValidationEvent> events) {
            this.traitFactory = Objects.requireNonNull(traitFactory, "Trait factory must not be null");
            this.events = Objects.requireNonNull(events, "events must not be null");
        }

        @Override
        public Map<ShapeId, Map<ShapeId, Trait>> traits() {
            return this.targetToTraits;
        }

        @Override
        public Map<ShapeId, Trait> getTraitsForShape(ShapeId shape) {
            return this.targetToTraits.getOrDefault(shape, Collections.emptyMap());
        }

        @Override
        public void clearTraitsForShape(ShapeId shape) {
            this.targetToTraits.remove(shape);
        }

        @Override
        public Map<ShapeId, Map<ShapeId, Trait>> getTraitsAppliedToPrelude() {
            return this.traitsAppliedToPrelude;
        }

        @Override
        public void onTrait(ShapeId target, Trait value) {
            ShapeId traitId = value.toShapeId();
            Map traits = this.targetToTraits.computeIfAbsent(target, id -> new HashMap());
            if (traits.containsKey(traitId)) {
                Trait previousTrait = (Trait)traits.get(traitId);
                if (LoaderUtils.isSameLocation(previousTrait, value) && previousTrait.equals(value)) {
                    LOGGER.finest(() -> String.format("Ignoring duplicate %s trait value on %s at same exact location", traitId, target));
                    return;
                }
                Node previous = previousTrait.toNode();
                Node updated = value.toNode();
                if (previous.isArrayNode() && updated.isArrayNode()) {
                    ArrayNode merged = previous.expectArrayNode().merge(updated.expectArrayNode());
                    value = this.createTrait(target, traitId, merged);
                    if (value == null) {
                        return;
                    }
                } else {
                    if (previous.equals(updated)) {
                        LOGGER.fine(() -> String.format("Ignoring duplicate %s trait value on %s", traitId, target));
                        return;
                    }
                    this.events.add(ValidationEvent.builder().id("Model").severity(Severity.ERROR).sourceLocation(value.getSourceLocation()).shapeId(target).message(String.format("Conflicting `%s` trait found on shape `%s`. The previous trait was defined at `%s`, and a conflicting trait was defined at `%s`.", traitId, target, previous.getSourceLocation(), value.getSourceLocation())).build());
                    return;
                }
            }
            traits.put(traitId, value);
            if (target.getNamespace().equals("smithy.api")) {
                this.traitsAppliedToPrelude.computeIfAbsent(target, id -> new HashMap()).put(traitId, value);
            }
        }

        @Override
        public void onTrait(ShapeId target, ShapeId traitId, Node value) {
            Trait trait = this.createTrait(target, traitId, value);
            if (trait != null) {
                this.onTrait(target, trait);
            }
        }

        private Trait createTrait(ShapeId target, ShapeId traitId, Node traitValue) {
            try {
                return this.traitFactory.createTrait(traitId, target, traitValue).orElseGet(() -> new DynamicTrait(traitId, traitValue));
            }
            catch (SourceException e) {
                String message = String.format("Error creating trait `%s`: ", Trait.getIdiomaticTraitName(traitId));
                this.events.add(ValidationEvent.fromSourceException(e, message).toBuilder().shapeId(target).build());
                return null;
            }
        }
    }
}

